"""Automatically generated by binding_generator.py.

MuJoCo header version: 200
"""

from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import ctypes
# pylint: disable=undefined-variable
# pylint: disable=wildcard-import
from dm_control.mujoco.wrapper import util
from dm_control.mujoco.wrapper.mjbindings.types import *

# --------------------------Low-level wrapper classes--------------------------


class MjLROptWrapper(util.WrapperBase):
  """options for mj_setLengthRange()."""

  @property
  def mode(self):
    """which actuators to process (mjtLRMode)."""
    return self._ptr.contents.mode

  @mode.setter
  def mode(self, value):
    self._ptr.contents.mode = value

  @property
  def useexisting(self):
    """use existing length range if available."""
    return self._ptr.contents.useexisting

  @useexisting.setter
  def useexisting(self, value):
    self._ptr.contents.useexisting = value

  @property
  def uselimit(self):
    """use joint and tendon limits if available."""
    return self._ptr.contents.uselimit

  @uselimit.setter
  def uselimit(self, value):
    self._ptr.contents.uselimit = value

  @property
  def accel(self):
    """target acceleration used to compute force."""
    return self._ptr.contents.accel

  @accel.setter
  def accel(self, value):
    self._ptr.contents.accel = value

  @property
  def maxforce(self):
    """maximum force; 0: no limit."""
    return self._ptr.contents.maxforce

  @maxforce.setter
  def maxforce(self, value):
    self._ptr.contents.maxforce = value

  @property
  def timeconst(self):
    """time constant for velocity reduction; min 0.01."""
    return self._ptr.contents.timeconst

  @timeconst.setter
  def timeconst(self, value):
    self._ptr.contents.timeconst = value

  @property
  def timestep(self):
    """simulation timestep; 0: use mjOption.timestep."""
    return self._ptr.contents.timestep

  @timestep.setter
  def timestep(self, value):
    self._ptr.contents.timestep = value

  @property
  def inttotal(self):
    """total simulation time interval."""
    return self._ptr.contents.inttotal

  @inttotal.setter
  def inttotal(self, value):
    self._ptr.contents.inttotal = value

  @property
  def inteval(self):
    """evaluation time interval (at the end)."""
    return self._ptr.contents.inteval

  @inteval.setter
  def inteval(self, value):
    self._ptr.contents.inteval = value

  @property
  def tolrange(self):
    """convergence tolerance (relative to range)."""
    return self._ptr.contents.tolrange

  @tolrange.setter
  def tolrange(self, value):
    self._ptr.contents.tolrange = value


class MjVFSWrapper(util.WrapperBase):
  """virtual file system for loading from memory."""

  @property
  def nfile(self):
    """number of files present."""
    return self._ptr.contents.nfile

  @nfile.setter
  def nfile(self, value):
    self._ptr.contents.nfile = value

  @property
  def filename(self):
    """file name without path."""
    return self._ptr.contents.filename

  @util.CachedProperty
  def filesize(self):
    """file size in bytes."""
    return util.buf_to_npy(self._ptr.contents.filesize, (200,))

  @property
  def filedata(self):
    """buffer with file data."""
    return self._ptr.contents.filedata


class MjOptionWrapper(util.WrapperBase):
  """physics options."""

  @property
  def timestep(self):
    """timestep."""
    return self._ptr.contents.timestep

  @timestep.setter
  def timestep(self, value):
    self._ptr.contents.timestep = value

  @property
  def apirate(self):
    """update rate for remote API (Hz)."""
    return self._ptr.contents.apirate

  @apirate.setter
  def apirate(self, value):
    self._ptr.contents.apirate = value

  @property
  def impratio(self):
    """ratio of friction-to-normal contact impedance."""
    return self._ptr.contents.impratio

  @impratio.setter
  def impratio(self, value):
    self._ptr.contents.impratio = value

  @property
  def tolerance(self):
    """main solver tolerance."""
    return self._ptr.contents.tolerance

  @tolerance.setter
  def tolerance(self, value):
    self._ptr.contents.tolerance = value

  @property
  def noslip_tolerance(self):
    """noslip solver tolerance."""
    return self._ptr.contents.noslip_tolerance

  @noslip_tolerance.setter
  def noslip_tolerance(self, value):
    self._ptr.contents.noslip_tolerance = value

  @property
  def mpr_tolerance(self):
    """MPR solver tolerance."""
    return self._ptr.contents.mpr_tolerance

  @mpr_tolerance.setter
  def mpr_tolerance(self, value):
    self._ptr.contents.mpr_tolerance = value

  @util.CachedProperty
  def gravity(self):
    """gravitational acceleration."""
    return util.buf_to_npy(self._ptr.contents.gravity, (3,))

  @util.CachedProperty
  def wind(self):
    """wind (for lift, drag and viscosity)."""
    return util.buf_to_npy(self._ptr.contents.wind, (3,))

  @util.CachedProperty
  def magnetic(self):
    """global magnetic flux."""
    return util.buf_to_npy(self._ptr.contents.magnetic, (3,))

  @property
  def density(self):
    """density of medium."""
    return self._ptr.contents.density

  @density.setter
  def density(self, value):
    self._ptr.contents.density = value

  @property
  def viscosity(self):
    """viscosity of medium."""
    return self._ptr.contents.viscosity

  @viscosity.setter
  def viscosity(self, value):
    self._ptr.contents.viscosity = value

  @property
  def o_margin(self):
    """margin."""
    return self._ptr.contents.o_margin

  @o_margin.setter
  def o_margin(self, value):
    self._ptr.contents.o_margin = value

  @util.CachedProperty
  def o_solref(self):
    """solref."""
    return util.buf_to_npy(self._ptr.contents.o_solref, (2,))

  @util.CachedProperty
  def o_solimp(self):
    """solimp."""
    return util.buf_to_npy(self._ptr.contents.o_solimp, (5,))

  @property
  def integrator(self):
    """integration mode (mjtIntegrator)."""
    return self._ptr.contents.integrator

  @integrator.setter
  def integrator(self, value):
    self._ptr.contents.integrator = value

  @property
  def collision(self):
    """collision mode (mjtCollision)."""
    return self._ptr.contents.collision

  @collision.setter
  def collision(self, value):
    self._ptr.contents.collision = value

  @property
  def cone(self):
    """type of friction cone (mjtCone)."""
    return self._ptr.contents.cone

  @cone.setter
  def cone(self, value):
    self._ptr.contents.cone = value

  @property
  def jacobian(self):
    """type of Jacobian (mjtJacobian)."""
    return self._ptr.contents.jacobian

  @jacobian.setter
  def jacobian(self, value):
    self._ptr.contents.jacobian = value

  @property
  def solver(self):
    """solver algorithm (mjtSolver)."""
    return self._ptr.contents.solver

  @solver.setter
  def solver(self, value):
    self._ptr.contents.solver = value

  @property
  def iterations(self):
    """maximum number of main solver iterations."""
    return self._ptr.contents.iterations

  @iterations.setter
  def iterations(self, value):
    self._ptr.contents.iterations = value

  @property
  def noslip_iterations(self):
    """maximum number of noslip solver iterations."""
    return self._ptr.contents.noslip_iterations

  @noslip_iterations.setter
  def noslip_iterations(self, value):
    self._ptr.contents.noslip_iterations = value

  @property
  def mpr_iterations(self):
    """maximum number of MPR solver iterations."""
    return self._ptr.contents.mpr_iterations

  @mpr_iterations.setter
  def mpr_iterations(self, value):
    self._ptr.contents.mpr_iterations = value

  @property
  def disableflags(self):
    """bit flags for disabling standard features."""
    return self._ptr.contents.disableflags

  @disableflags.setter
  def disableflags(self, value):
    self._ptr.contents.disableflags = value

  @property
  def enableflags(self):
    """bit flags for enabling optional features."""
    return self._ptr.contents.enableflags

  @enableflags.setter
  def enableflags(self, value):
    self._ptr.contents.enableflags = value


class GlobalWrapper(util.WrapperBase):
  """global parameters."""

  @property
  def fovy(self):
    """y-field of view (deg) for free camera."""
    return self._ptr.contents.fovy

  @fovy.setter
  def fovy(self, value):
    self._ptr.contents.fovy = value

  @property
  def ipd(self):
    """inter-pupilary distance for free camera."""
    return self._ptr.contents.ipd

  @ipd.setter
  def ipd(self, value):
    self._ptr.contents.ipd = value

  @property
  def linewidth(self):
    """line width for wireframe and ray rendering."""
    return self._ptr.contents.linewidth

  @linewidth.setter
  def linewidth(self, value):
    self._ptr.contents.linewidth = value

  @property
  def glow(self):
    """glow coefficient for selected body."""
    return self._ptr.contents.glow

  @glow.setter
  def glow(self, value):
    self._ptr.contents.glow = value

  @property
  def offwidth(self):
    """width of offscreen buffer."""
    return self._ptr.contents.offwidth

  @offwidth.setter
  def offwidth(self, value):
    self._ptr.contents.offwidth = value

  @property
  def offheight(self):
    """height of offscreen buffer."""
    return self._ptr.contents.offheight

  @offheight.setter
  def offheight(self, value):
    self._ptr.contents.offheight = value


class QualityWrapper(util.WrapperBase):
  """rendering quality."""

  @property
  def shadowsize(self):
    """size of shadowmap texture."""
    return self._ptr.contents.shadowsize

  @shadowsize.setter
  def shadowsize(self, value):
    self._ptr.contents.shadowsize = value

  @property
  def offsamples(self):
    """number of multisamples for offscreen rendering."""
    return self._ptr.contents.offsamples

  @offsamples.setter
  def offsamples(self, value):
    self._ptr.contents.offsamples = value

  @property
  def numslices(self):
    """number of slices for builtin geom drawing."""
    return self._ptr.contents.numslices

  @numslices.setter
  def numslices(self, value):
    self._ptr.contents.numslices = value

  @property
  def numstacks(self):
    """number of stacks for builtin geom drawing."""
    return self._ptr.contents.numstacks

  @numstacks.setter
  def numstacks(self, value):
    self._ptr.contents.numstacks = value

  @property
  def numquads(self):
    """number of quads for box rendering."""
    return self._ptr.contents.numquads

  @numquads.setter
  def numquads(self, value):
    self._ptr.contents.numquads = value


class HeadlightWrapper(util.WrapperBase):
  """head light."""

  @util.CachedProperty
  def ambient(self):
    """ambient rgb (alpha=1)."""
    return util.buf_to_npy(self._ptr.contents.ambient, (3,))

  @util.CachedProperty
  def diffuse(self):
    """diffuse rgb (alpha=1)."""
    return util.buf_to_npy(self._ptr.contents.diffuse, (3,))

  @util.CachedProperty
  def specular(self):
    """specular rgb (alpha=1)."""
    return util.buf_to_npy(self._ptr.contents.specular, (3,))

  @property
  def active(self):
    """is headlight active."""
    return self._ptr.contents.active

  @active.setter
  def active(self, value):
    self._ptr.contents.active = value


class MapWrapper(util.WrapperBase):
  """mapping."""

  @property
  def stiffness(self):
    """mouse perturbation stiffness (space->force)."""
    return self._ptr.contents.stiffness

  @stiffness.setter
  def stiffness(self, value):
    self._ptr.contents.stiffness = value

  @property
  def stiffnessrot(self):
    """mouse perturbation stiffness (space->torque)."""
    return self._ptr.contents.stiffnessrot

  @stiffnessrot.setter
  def stiffnessrot(self, value):
    self._ptr.contents.stiffnessrot = value

  @property
  def force(self):
    """from force units to space units."""
    return self._ptr.contents.force

  @force.setter
  def force(self, value):
    self._ptr.contents.force = value

  @property
  def torque(self):
    """from torque units to space units."""
    return self._ptr.contents.torque

  @torque.setter
  def torque(self, value):
    self._ptr.contents.torque = value

  @property
  def alpha(self):
    """scale geom alphas when transparency is enabled."""
    return self._ptr.contents.alpha

  @alpha.setter
  def alpha(self, value):
    self._ptr.contents.alpha = value

  @property
  def fogstart(self):
    """OpenGL fog starts at fogstart * mjModel.stat.extent."""
    return self._ptr.contents.fogstart

  @fogstart.setter
  def fogstart(self, value):
    self._ptr.contents.fogstart = value

  @property
  def fogend(self):
    """OpenGL fog ends at fogend * mjModel.stat.extent."""
    return self._ptr.contents.fogend

  @fogend.setter
  def fogend(self, value):
    self._ptr.contents.fogend = value

  @property
  def znear(self):
    """near clipping plane = znear * mjModel.stat.extent."""
    return self._ptr.contents.znear

  @znear.setter
  def znear(self, value):
    self._ptr.contents.znear = value

  @property
  def zfar(self):
    """far clipping plane = zfar * mjModel.stat.extent."""
    return self._ptr.contents.zfar

  @zfar.setter
  def zfar(self, value):
    self._ptr.contents.zfar = value

  @property
  def haze(self):
    """haze ratio."""
    return self._ptr.contents.haze

  @haze.setter
  def haze(self, value):
    self._ptr.contents.haze = value

  @property
  def shadowclip(self):
    """directional light: shadowclip * mjModel.stat.extent."""
    return self._ptr.contents.shadowclip

  @shadowclip.setter
  def shadowclip(self, value):
    self._ptr.contents.shadowclip = value

  @property
  def shadowscale(self):
    """spot light: shadowscale * light.cutoff."""
    return self._ptr.contents.shadowscale

  @shadowscale.setter
  def shadowscale(self, value):
    self._ptr.contents.shadowscale = value

  @property
  def actuatortendon(self):
    """scale tendon width."""
    return self._ptr.contents.actuatortendon

  @actuatortendon.setter
  def actuatortendon(self, value):
    self._ptr.contents.actuatortendon = value


class ScaleWrapper(util.WrapperBase):
  """scale of decor elements relative to mean body size."""

  @property
  def forcewidth(self):
    """width of force arrow."""
    return self._ptr.contents.forcewidth

  @forcewidth.setter
  def forcewidth(self, value):
    self._ptr.contents.forcewidth = value

  @property
  def contactwidth(self):
    """contact width."""
    return self._ptr.contents.contactwidth

  @contactwidth.setter
  def contactwidth(self, value):
    self._ptr.contents.contactwidth = value

  @property
  def contactheight(self):
    """contact height."""
    return self._ptr.contents.contactheight

  @contactheight.setter
  def contactheight(self, value):
    self._ptr.contents.contactheight = value

  @property
  def connect(self):
    """autoconnect capsule width."""
    return self._ptr.contents.connect

  @connect.setter
  def connect(self, value):
    self._ptr.contents.connect = value

  @property
  def com(self):
    """com radius."""
    return self._ptr.contents.com

  @com.setter
  def com(self, value):
    self._ptr.contents.com = value

  @property
  def camera(self):
    """camera object."""
    return self._ptr.contents.camera

  @camera.setter
  def camera(self, value):
    self._ptr.contents.camera = value

  @property
  def light(self):
    """light object."""
    return self._ptr.contents.light

  @light.setter
  def light(self, value):
    self._ptr.contents.light = value

  @property
  def selectpoint(self):
    """selection point."""
    return self._ptr.contents.selectpoint

  @selectpoint.setter
  def selectpoint(self, value):
    self._ptr.contents.selectpoint = value

  @property
  def jointlength(self):
    """joint length."""
    return self._ptr.contents.jointlength

  @jointlength.setter
  def jointlength(self, value):
    self._ptr.contents.jointlength = value

  @property
  def jointwidth(self):
    """joint width."""
    return self._ptr.contents.jointwidth

  @jointwidth.setter
  def jointwidth(self, value):
    self._ptr.contents.jointwidth = value

  @property
  def actuatorlength(self):
    """actuator length."""
    return self._ptr.contents.actuatorlength

  @actuatorlength.setter
  def actuatorlength(self, value):
    self._ptr.contents.actuatorlength = value

  @property
  def actuatorwidth(self):
    """actuator width."""
    return self._ptr.contents.actuatorwidth

  @actuatorwidth.setter
  def actuatorwidth(self, value):
    self._ptr.contents.actuatorwidth = value

  @property
  def framelength(self):
    """bodyframe axis length."""
    return self._ptr.contents.framelength

  @framelength.setter
  def framelength(self, value):
    self._ptr.contents.framelength = value

  @property
  def framewidth(self):
    """bodyframe axis width."""
    return self._ptr.contents.framewidth

  @framewidth.setter
  def framewidth(self, value):
    self._ptr.contents.framewidth = value

  @property
  def constraint(self):
    """constraint width."""
    return self._ptr.contents.constraint

  @constraint.setter
  def constraint(self, value):
    self._ptr.contents.constraint = value

  @property
  def slidercrank(self):
    """slidercrank width."""
    return self._ptr.contents.slidercrank

  @slidercrank.setter
  def slidercrank(self, value):
    self._ptr.contents.slidercrank = value


class RgbaWrapper(util.WrapperBase):
  """color of decor elements."""

  @util.CachedProperty
  def fog(self):
    """fog."""
    return util.buf_to_npy(self._ptr.contents.fog, (4,))

  @util.CachedProperty
  def haze(self):
    """haze."""
    return util.buf_to_npy(self._ptr.contents.haze, (4,))

  @util.CachedProperty
  def force(self):
    """external force."""
    return util.buf_to_npy(self._ptr.contents.force, (4,))

  @util.CachedProperty
  def inertia(self):
    """inertia box."""
    return util.buf_to_npy(self._ptr.contents.inertia, (4,))

  @util.CachedProperty
  def joint(self):
    """joint."""
    return util.buf_to_npy(self._ptr.contents.joint, (4,))

  @util.CachedProperty
  def actuator(self):
    """actuator, neutral."""
    return util.buf_to_npy(self._ptr.contents.actuator, (4,))

  @util.CachedProperty
  def actuatornegative(self):
    """actuator, negative limit."""
    return util.buf_to_npy(self._ptr.contents.actuatornegative, (4,))

  @util.CachedProperty
  def actuatorpositive(self):
    """actuator, positive limit."""
    return util.buf_to_npy(self._ptr.contents.actuatorpositive, (4,))

  @util.CachedProperty
  def com(self):
    """center of mass."""
    return util.buf_to_npy(self._ptr.contents.com, (4,))

  @util.CachedProperty
  def camera(self):
    """camera object."""
    return util.buf_to_npy(self._ptr.contents.camera, (4,))

  @util.CachedProperty
  def light(self):
    """light object."""
    return util.buf_to_npy(self._ptr.contents.light, (4,))

  @util.CachedProperty
  def selectpoint(self):
    """selection point."""
    return util.buf_to_npy(self._ptr.contents.selectpoint, (4,))

  @util.CachedProperty
  def connect(self):
    """auto connect."""
    return util.buf_to_npy(self._ptr.contents.connect, (4,))

  @util.CachedProperty
  def contactpoint(self):
    """contact point."""
    return util.buf_to_npy(self._ptr.contents.contactpoint, (4,))

  @util.CachedProperty
  def contactforce(self):
    """contact force."""
    return util.buf_to_npy(self._ptr.contents.contactforce, (4,))

  @util.CachedProperty
  def contactfriction(self):
    """contact friction force."""
    return util.buf_to_npy(self._ptr.contents.contactfriction, (4,))

  @util.CachedProperty
  def contacttorque(self):
    """contact torque."""
    return util.buf_to_npy(self._ptr.contents.contacttorque, (4,))

  @util.CachedProperty
  def contactgap(self):
    """contact point in gap."""
    return util.buf_to_npy(self._ptr.contents.contactgap, (4,))

  @util.CachedProperty
  def rangefinder(self):
    """rangefinder ray."""
    return util.buf_to_npy(self._ptr.contents.rangefinder, (4,))

  @util.CachedProperty
  def constraint(self):
    """constraint."""
    return util.buf_to_npy(self._ptr.contents.constraint, (4,))

  @util.CachedProperty
  def slidercrank(self):
    """slidercrank."""
    return util.buf_to_npy(self._ptr.contents.slidercrank, (4,))

  @util.CachedProperty
  def crankbroken(self):
    """used when crank must be stretched/broken."""
    return util.buf_to_npy(self._ptr.contents.crankbroken, (4,))


class MjVisualWrapper(util.WrapperBase):
  """visualization options."""

  @util.CachedProperty
  def global_(self):
    """global parameters."""
    return GlobalWrapper(ctypes.pointer(self._ptr.contents.global_))

  @util.CachedProperty
  def quality(self):
    """rendering quality."""
    return QualityWrapper(ctypes.pointer(self._ptr.contents.quality))

  @util.CachedProperty
  def headlight(self):
    """head light."""
    return HeadlightWrapper(ctypes.pointer(self._ptr.contents.headlight))

  @util.CachedProperty
  def map_(self):
    """mapping."""
    return MapWrapper(ctypes.pointer(self._ptr.contents.map_))

  @util.CachedProperty
  def scale(self):
    """scale of decor elements relative to mean body size."""
    return ScaleWrapper(ctypes.pointer(self._ptr.contents.scale))

  @util.CachedProperty
  def rgba(self):
    """color of decor elements."""
    return RgbaWrapper(ctypes.pointer(self._ptr.contents.rgba))


class MjStatisticWrapper(util.WrapperBase):
  """model statistics (in qpos0)."""

  @property
  def meaninertia(self):
    """mean diagonal inertia."""
    return self._ptr.contents.meaninertia

  @meaninertia.setter
  def meaninertia(self, value):
    self._ptr.contents.meaninertia = value

  @property
  def meanmass(self):
    """mean body mass."""
    return self._ptr.contents.meanmass

  @meanmass.setter
  def meanmass(self, value):
    self._ptr.contents.meanmass = value

  @property
  def meansize(self):
    """mean body size."""
    return self._ptr.contents.meansize

  @meansize.setter
  def meansize(self, value):
    self._ptr.contents.meansize = value

  @property
  def extent(self):
    """spatial extent."""
    return self._ptr.contents.extent

  @extent.setter
  def extent(self, value):
    self._ptr.contents.extent = value

  @util.CachedProperty
  def center(self):
    """center of model."""
    return util.buf_to_npy(self._ptr.contents.center, (3,))


class MjModelWrapper(util.WrapperBase):
  """<no header comment found>."""

  @property
  def nq(self):
    """number of generalized coordinates = dim(qpos)."""
    return self._ptr.contents.nq

  @nq.setter
  def nq(self, value):
    self._ptr.contents.nq = value

  @property
  def nv(self):
    """number of degrees of freedom = dim(qvel)."""
    return self._ptr.contents.nv

  @nv.setter
  def nv(self, value):
    self._ptr.contents.nv = value

  @property
  def nu(self):
    """number of actuators/controls = dim(ctrl)."""
    return self._ptr.contents.nu

  @nu.setter
  def nu(self, value):
    self._ptr.contents.nu = value

  @property
  def na(self):
    """number of activation states = dim(act)."""
    return self._ptr.contents.na

  @na.setter
  def na(self, value):
    self._ptr.contents.na = value

  @property
  def nbody(self):
    """number of bodies."""
    return self._ptr.contents.nbody

  @nbody.setter
  def nbody(self, value):
    self._ptr.contents.nbody = value

  @property
  def njnt(self):
    """number of joints."""
    return self._ptr.contents.njnt

  @njnt.setter
  def njnt(self, value):
    self._ptr.contents.njnt = value

  @property
  def ngeom(self):
    """number of geoms."""
    return self._ptr.contents.ngeom

  @ngeom.setter
  def ngeom(self, value):
    self._ptr.contents.ngeom = value

  @property
  def nsite(self):
    """number of sites."""
    return self._ptr.contents.nsite

  @nsite.setter
  def nsite(self, value):
    self._ptr.contents.nsite = value

  @property
  def ncam(self):
    """number of cameras."""
    return self._ptr.contents.ncam

  @ncam.setter
  def ncam(self, value):
    self._ptr.contents.ncam = value

  @property
  def nlight(self):
    """number of lights."""
    return self._ptr.contents.nlight

  @nlight.setter
  def nlight(self, value):
    self._ptr.contents.nlight = value

  @property
  def nmesh(self):
    """number of meshes."""
    return self._ptr.contents.nmesh

  @nmesh.setter
  def nmesh(self, value):
    self._ptr.contents.nmesh = value

  @property
  def nmeshvert(self):
    """number of vertices in all meshes."""
    return self._ptr.contents.nmeshvert

  @nmeshvert.setter
  def nmeshvert(self, value):
    self._ptr.contents.nmeshvert = value

  @property
  def nmeshtexvert(self):
    """number of vertices with texcoords in all meshes."""
    return self._ptr.contents.nmeshtexvert

  @nmeshtexvert.setter
  def nmeshtexvert(self, value):
    self._ptr.contents.nmeshtexvert = value

  @property
  def nmeshface(self):
    """number of triangular faces in all meshes."""
    return self._ptr.contents.nmeshface

  @nmeshface.setter
  def nmeshface(self, value):
    self._ptr.contents.nmeshface = value

  @property
  def nmeshgraph(self):
    """number of ints in mesh auxiliary data."""
    return self._ptr.contents.nmeshgraph

  @nmeshgraph.setter
  def nmeshgraph(self, value):
    self._ptr.contents.nmeshgraph = value

  @property
  def nskin(self):
    """number of skins."""
    return self._ptr.contents.nskin

  @nskin.setter
  def nskin(self, value):
    self._ptr.contents.nskin = value

  @property
  def nskinvert(self):
    """number of vertices in all skins."""
    return self._ptr.contents.nskinvert

  @nskinvert.setter
  def nskinvert(self, value):
    self._ptr.contents.nskinvert = value

  @property
  def nskintexvert(self):
    """number of vertiex with texcoords in all skins."""
    return self._ptr.contents.nskintexvert

  @nskintexvert.setter
  def nskintexvert(self, value):
    self._ptr.contents.nskintexvert = value

  @property
  def nskinface(self):
    """number of triangular faces in all skins."""
    return self._ptr.contents.nskinface

  @nskinface.setter
  def nskinface(self, value):
    self._ptr.contents.nskinface = value

  @property
  def nskinbone(self):
    """number of bones in all skins."""
    return self._ptr.contents.nskinbone

  @nskinbone.setter
  def nskinbone(self, value):
    self._ptr.contents.nskinbone = value

  @property
  def nskinbonevert(self):
    """number of vertices in all skin bones."""
    return self._ptr.contents.nskinbonevert

  @nskinbonevert.setter
  def nskinbonevert(self, value):
    self._ptr.contents.nskinbonevert = value

  @property
  def nhfield(self):
    """number of heightfields."""
    return self._ptr.contents.nhfield

  @nhfield.setter
  def nhfield(self, value):
    self._ptr.contents.nhfield = value

  @property
  def nhfielddata(self):
    """number of data points in all heightfields."""
    return self._ptr.contents.nhfielddata

  @nhfielddata.setter
  def nhfielddata(self, value):
    self._ptr.contents.nhfielddata = value

  @property
  def ntex(self):
    """number of textures."""
    return self._ptr.contents.ntex

  @ntex.setter
  def ntex(self, value):
    self._ptr.contents.ntex = value

  @property
  def ntexdata(self):
    """number of bytes in texture rgb data."""
    return self._ptr.contents.ntexdata

  @ntexdata.setter
  def ntexdata(self, value):
    self._ptr.contents.ntexdata = value

  @property
  def nmat(self):
    """number of materials."""
    return self._ptr.contents.nmat

  @nmat.setter
  def nmat(self, value):
    self._ptr.contents.nmat = value

  @property
  def npair(self):
    """number of predefined geom pairs."""
    return self._ptr.contents.npair

  @npair.setter
  def npair(self, value):
    self._ptr.contents.npair = value

  @property
  def nexclude(self):
    """number of excluded geom pairs."""
    return self._ptr.contents.nexclude

  @nexclude.setter
  def nexclude(self, value):
    self._ptr.contents.nexclude = value

  @property
  def neq(self):
    """number of equality constraints."""
    return self._ptr.contents.neq

  @neq.setter
  def neq(self, value):
    self._ptr.contents.neq = value

  @property
  def ntendon(self):
    """number of tendons."""
    return self._ptr.contents.ntendon

  @ntendon.setter
  def ntendon(self, value):
    self._ptr.contents.ntendon = value

  @property
  def nwrap(self):
    """number of wrap objects in all tendon paths."""
    return self._ptr.contents.nwrap

  @nwrap.setter
  def nwrap(self, value):
    self._ptr.contents.nwrap = value

  @property
  def nsensor(self):
    """number of sensors."""
    return self._ptr.contents.nsensor

  @nsensor.setter
  def nsensor(self, value):
    self._ptr.contents.nsensor = value

  @property
  def nnumeric(self):
    """number of numeric custom fields."""
    return self._ptr.contents.nnumeric

  @nnumeric.setter
  def nnumeric(self, value):
    self._ptr.contents.nnumeric = value

  @property
  def nnumericdata(self):
    """number of mjtNums in all numeric fields."""
    return self._ptr.contents.nnumericdata

  @nnumericdata.setter
  def nnumericdata(self, value):
    self._ptr.contents.nnumericdata = value

  @property
  def ntext(self):
    """number of text custom fields."""
    return self._ptr.contents.ntext

  @ntext.setter
  def ntext(self, value):
    self._ptr.contents.ntext = value

  @property
  def ntextdata(self):
    """number of mjtBytes in all text fields."""
    return self._ptr.contents.ntextdata

  @ntextdata.setter
  def ntextdata(self, value):
    self._ptr.contents.ntextdata = value

  @property
  def ntuple(self):
    """number of tuple custom fields."""
    return self._ptr.contents.ntuple

  @ntuple.setter
  def ntuple(self, value):
    self._ptr.contents.ntuple = value

  @property
  def ntupledata(self):
    """number of objects in all tuple fields."""
    return self._ptr.contents.ntupledata

  @ntupledata.setter
  def ntupledata(self, value):
    self._ptr.contents.ntupledata = value

  @property
  def nkey(self):
    """number of keyframes."""
    return self._ptr.contents.nkey

  @nkey.setter
  def nkey(self, value):
    self._ptr.contents.nkey = value

  @property
  def nuser_body(self):
    """number of mjtNums in body_user."""
    return self._ptr.contents.nuser_body

  @nuser_body.setter
  def nuser_body(self, value):
    self._ptr.contents.nuser_body = value

  @property
  def nuser_jnt(self):
    """number of mjtNums in jnt_user."""
    return self._ptr.contents.nuser_jnt

  @nuser_jnt.setter
  def nuser_jnt(self, value):
    self._ptr.contents.nuser_jnt = value

  @property
  def nuser_geom(self):
    """number of mjtNums in geom_user."""
    return self._ptr.contents.nuser_geom

  @nuser_geom.setter
  def nuser_geom(self, value):
    self._ptr.contents.nuser_geom = value

  @property
  def nuser_site(self):
    """number of mjtNums in site_user."""
    return self._ptr.contents.nuser_site

  @nuser_site.setter
  def nuser_site(self, value):
    self._ptr.contents.nuser_site = value

  @property
  def nuser_cam(self):
    """number of mjtNums in cam_user."""
    return self._ptr.contents.nuser_cam

  @nuser_cam.setter
  def nuser_cam(self, value):
    self._ptr.contents.nuser_cam = value

  @property
  def nuser_tendon(self):
    """number of mjtNums in tendon_user."""
    return self._ptr.contents.nuser_tendon

  @nuser_tendon.setter
  def nuser_tendon(self, value):
    self._ptr.contents.nuser_tendon = value

  @property
  def nuser_actuator(self):
    """number of mjtNums in actuator_user."""
    return self._ptr.contents.nuser_actuator

  @nuser_actuator.setter
  def nuser_actuator(self, value):
    self._ptr.contents.nuser_actuator = value

  @property
  def nuser_sensor(self):
    """number of mjtNums in sensor_user."""
    return self._ptr.contents.nuser_sensor

  @nuser_sensor.setter
  def nuser_sensor(self, value):
    self._ptr.contents.nuser_sensor = value

  @property
  def nnames(self):
    """number of chars in all names."""
    return self._ptr.contents.nnames

  @nnames.setter
  def nnames(self, value):
    self._ptr.contents.nnames = value

  @property
  def nM(self):
    """number of non-zeros in sparse inertia matrix."""
    return self._ptr.contents.nM

  @nM.setter
  def nM(self, value):
    self._ptr.contents.nM = value

  @property
  def nemax(self):
    """number of potential equality-constraint rows."""
    return self._ptr.contents.nemax

  @nemax.setter
  def nemax(self, value):
    self._ptr.contents.nemax = value

  @property
  def njmax(self):
    """number of available rows in constraint Jacobian."""
    return self._ptr.contents.njmax

  @njmax.setter
  def njmax(self, value):
    self._ptr.contents.njmax = value

  @property
  def nconmax(self):
    """number of potential contacts in contact list."""
    return self._ptr.contents.nconmax

  @nconmax.setter
  def nconmax(self, value):
    self._ptr.contents.nconmax = value

  @property
  def nstack(self):
    """number of fields in mjData stack."""
    return self._ptr.contents.nstack

  @nstack.setter
  def nstack(self, value):
    self._ptr.contents.nstack = value

  @property
  def nuserdata(self):
    """number of extra fields in mjData."""
    return self._ptr.contents.nuserdata

  @nuserdata.setter
  def nuserdata(self, value):
    self._ptr.contents.nuserdata = value

  @property
  def nmocap(self):
    """number of mocap bodies."""
    return self._ptr.contents.nmocap

  @nmocap.setter
  def nmocap(self, value):
    self._ptr.contents.nmocap = value

  @property
  def nsensordata(self):
    """number of fields in sensor data vector."""
    return self._ptr.contents.nsensordata

  @nsensordata.setter
  def nsensordata(self, value):
    self._ptr.contents.nsensordata = value

  @property
  def nbuffer(self):
    """number of bytes in buffer."""
    return self._ptr.contents.nbuffer

  @nbuffer.setter
  def nbuffer(self, value):
    self._ptr.contents.nbuffer = value

  @util.CachedProperty
  def opt(self):
    """physics options."""
    return MjOptionWrapper(ctypes.pointer(self._ptr.contents.opt))

  @util.CachedProperty
  def vis(self):
    """visualization options."""
    return MjVisualWrapper(ctypes.pointer(self._ptr.contents.vis))

  @util.CachedProperty
  def stat(self):
    """model statistics."""
    return MjStatisticWrapper(ctypes.pointer(self._ptr.contents.stat))

  @property
  def buffer_(self):
    """main buffer; all pointers point in it (nbuffer)."""
    return self._ptr.contents.buffer_

  @buffer_.setter
  def buffer_(self, value):
    self._ptr.contents.buffer_ = value

  @util.CachedProperty
  def qpos0(self):
    """qpos values at default pose (nq x 1)."""
    return util.buf_to_npy(self._ptr.contents.qpos0,
                           (self.nq,))

  @util.CachedProperty
  def qpos_spring(self):
    """reference pose for springs (nq x 1)."""
    return util.buf_to_npy(self._ptr.contents.qpos_spring,
                           (self.nq,))

  @util.CachedProperty
  def body_parentid(self):
    """id of body's parent (nbody x 1)."""
    return util.buf_to_npy(self._ptr.contents.body_parentid,
                           (self.nbody,))

  @util.CachedProperty
  def body_rootid(self):
    """id of root above body (nbody x 1)."""
    return util.buf_to_npy(self._ptr.contents.body_rootid,
                           (self.nbody,))

  @util.CachedProperty
  def body_weldid(self):
    """id of body that this body is welded to (nbody x 1)."""
    return util.buf_to_npy(self._ptr.contents.body_weldid,
                           (self.nbody,))

  @util.CachedProperty
  def body_mocapid(self):
    """id of mocap data; -1: none (nbody x 1)."""
    return util.buf_to_npy(self._ptr.contents.body_mocapid,
                           (self.nbody,))

  @util.CachedProperty
  def body_jntnum(self):
    """number of joints for this body (nbody x 1)."""
    return util.buf_to_npy(self._ptr.contents.body_jntnum,
                           (self.nbody,))

  @util.CachedProperty
  def body_jntadr(self):
    """start addr of joints; -1: no joints (nbody x 1)."""
    return util.buf_to_npy(self._ptr.contents.body_jntadr,
                           (self.nbody,))

  @util.CachedProperty
  def body_dofnum(self):
    """number of motion degrees of freedom (nbody x 1)."""
    return util.buf_to_npy(self._ptr.contents.body_dofnum,
                           (self.nbody,))

  @util.CachedProperty
  def body_dofadr(self):
    """start addr of dofs; -1: no dofs (nbody x 1)."""
    return util.buf_to_npy(self._ptr.contents.body_dofadr,
                           (self.nbody,))

  @util.CachedProperty
  def body_geomnum(self):
    """number of geoms (nbody x 1)."""
    return util.buf_to_npy(self._ptr.contents.body_geomnum,
                           (self.nbody,))

  @util.CachedProperty
  def body_geomadr(self):
    """start addr of geoms; -1: no geoms (nbody x 1)."""
    return util.buf_to_npy(self._ptr.contents.body_geomadr,
                           (self.nbody,))

  @util.CachedProperty
  def body_simple(self):
    """body is simple (has diagonal M) (nbody x 1)."""
    return util.buf_to_npy(self._ptr.contents.body_simple,
                           (self.nbody,))

  @util.CachedProperty
  def body_sameframe(self):
    """inertial frame is same as body frame (nbody x 1)."""
    return util.buf_to_npy(self._ptr.contents.body_sameframe,
                           (self.nbody,))

  @util.CachedProperty
  def body_pos(self):
    """position offset rel. to parent body (nbody x 3)."""
    return util.buf_to_npy(self._ptr.contents.body_pos,
                           (self.nbody, 3))

  @util.CachedProperty
  def body_quat(self):
    """orientation offset rel. to parent body (nbody x 4)."""
    return util.buf_to_npy(self._ptr.contents.body_quat,
                           (self.nbody, 4))

  @util.CachedProperty
  def body_ipos(self):
    """local position of center of mass (nbody x 3)."""
    return util.buf_to_npy(self._ptr.contents.body_ipos,
                           (self.nbody, 3))

  @util.CachedProperty
  def body_iquat(self):
    """local orientation of inertia ellipsoid (nbody x 4)."""
    return util.buf_to_npy(self._ptr.contents.body_iquat,
                           (self.nbody, 4))

  @util.CachedProperty
  def body_mass(self):
    """mass (nbody x 1)."""
    return util.buf_to_npy(self._ptr.contents.body_mass,
                           (self.nbody,))

  @util.CachedProperty
  def body_subtreemass(self):
    """mass of subtree starting at this body (nbody x 1)."""
    return util.buf_to_npy(self._ptr.contents.body_subtreemass,
                           (self.nbody,))

  @util.CachedProperty
  def body_inertia(self):
    """diagonal inertia in ipos/iquat frame (nbody x 3)."""
    return util.buf_to_npy(self._ptr.contents.body_inertia,
                           (self.nbody, 3))

  @util.CachedProperty
  def body_invweight0(self):
    """mean inv inert in qpos0 (trn, rot) (nbody x 2)."""
    return util.buf_to_npy(self._ptr.contents.body_invweight0,
                           (self.nbody, 2))

  @util.CachedProperty
  def body_user(self):
    """user data (nbody x nuser_body)."""
    return util.buf_to_npy(self._ptr.contents.body_user,
                           (self.nbody, self.nuser_body))

  @util.CachedProperty
  def jnt_type(self):
    """type of joint (mjtJoint) (njnt x 1)."""
    return util.buf_to_npy(self._ptr.contents.jnt_type,
                           (self.njnt,))

  @util.CachedProperty
  def jnt_qposadr(self):
    """start addr in 'qpos' for joint's data (njnt x 1)."""
    return util.buf_to_npy(self._ptr.contents.jnt_qposadr,
                           (self.njnt,))

  @util.CachedProperty
  def jnt_dofadr(self):
    """start addr in 'qvel' for joint's data (njnt x 1)."""
    return util.buf_to_npy(self._ptr.contents.jnt_dofadr,
                           (self.njnt,))

  @util.CachedProperty
  def jnt_bodyid(self):
    """id of joint's body (njnt x 1)."""
    return util.buf_to_npy(self._ptr.contents.jnt_bodyid,
                           (self.njnt,))

  @util.CachedProperty
  def jnt_group(self):
    """group for visibility (njnt x 1)."""
    return util.buf_to_npy(self._ptr.contents.jnt_group,
                           (self.njnt,))

  @util.CachedProperty
  def jnt_limited(self):
    """does joint have limits (njnt x 1)."""
    return util.buf_to_npy(self._ptr.contents.jnt_limited,
                           (self.njnt,))

  @util.CachedProperty
  def jnt_solref(self):
    """constraint solver reference: limit (njnt x mjNREF)."""
    return util.buf_to_npy(self._ptr.contents.jnt_solref,
                           (self.njnt, 2))

  @util.CachedProperty
  def jnt_solimp(self):
    """constraint solver impedance: limit (njnt x mjNIMP)."""
    return util.buf_to_npy(self._ptr.contents.jnt_solimp,
                           (self.njnt, 5))

  @util.CachedProperty
  def jnt_pos(self):
    """local anchor position (njnt x 3)."""
    return util.buf_to_npy(self._ptr.contents.jnt_pos,
                           (self.njnt, 3))

  @util.CachedProperty
  def jnt_axis(self):
    """local joint axis (njnt x 3)."""
    return util.buf_to_npy(self._ptr.contents.jnt_axis,
                           (self.njnt, 3))

  @util.CachedProperty
  def jnt_stiffness(self):
    """stiffness coefficient (njnt x 1)."""
    return util.buf_to_npy(self._ptr.contents.jnt_stiffness,
                           (self.njnt,))

  @util.CachedProperty
  def jnt_range(self):
    """joint limits (njnt x 2)."""
    return util.buf_to_npy(self._ptr.contents.jnt_range,
                           (self.njnt, 2))

  @util.CachedProperty
  def jnt_margin(self):
    """min distance for limit detection (njnt x 1)."""
    return util.buf_to_npy(self._ptr.contents.jnt_margin,
                           (self.njnt,))

  @util.CachedProperty
  def jnt_user(self):
    """user data (njnt x nuser_jnt)."""
    return util.buf_to_npy(self._ptr.contents.jnt_user,
                           (self.njnt, self.nuser_jnt))

  @util.CachedProperty
  def dof_bodyid(self):
    """id of dof's body (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.dof_bodyid,
                           (self.nv,))

  @util.CachedProperty
  def dof_jntid(self):
    """id of dof's joint (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.dof_jntid,
                           (self.nv,))

  @util.CachedProperty
  def dof_parentid(self):
    """id of dof's parent; -1: none (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.dof_parentid,
                           (self.nv,))

  @util.CachedProperty
  def dof_Madr(self):
    """dof address in M-diagonal (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.dof_Madr,
                           (self.nv,))

  @util.CachedProperty
  def dof_simplenum(self):
    """number of consecutive simple dofs (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.dof_simplenum,
                           (self.nv,))

  @util.CachedProperty
  def dof_solref(self):
    """constraint solver reference:frictionloss (nv x mjNREF)."""
    return util.buf_to_npy(self._ptr.contents.dof_solref,
                           (self.nv, 2))

  @util.CachedProperty
  def dof_solimp(self):
    """constraint solver impedance:frictionloss (nv x mjNIMP)."""
    return util.buf_to_npy(self._ptr.contents.dof_solimp,
                           (self.nv, 5))

  @util.CachedProperty
  def dof_frictionloss(self):
    """dof friction loss (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.dof_frictionloss,
                           (self.nv,))

  @util.CachedProperty
  def dof_armature(self):
    """dof armature inertia/mass (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.dof_armature,
                           (self.nv,))

  @util.CachedProperty
  def dof_damping(self):
    """damping coefficient (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.dof_damping,
                           (self.nv,))

  @util.CachedProperty
  def dof_invweight0(self):
    """diag. inverse inertia in qpos0 (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.dof_invweight0,
                           (self.nv,))

  @util.CachedProperty
  def dof_M0(self):
    """diag. inertia in qpos0 (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.dof_M0,
                           (self.nv,))

  @util.CachedProperty
  def geom_type(self):
    """geometric type (mjtGeom) (ngeom x 1)."""
    return util.buf_to_npy(self._ptr.contents.geom_type,
                           (self.ngeom,))

  @util.CachedProperty
  def geom_contype(self):
    """geom contact type (ngeom x 1)."""
    return util.buf_to_npy(self._ptr.contents.geom_contype,
                           (self.ngeom,))

  @util.CachedProperty
  def geom_conaffinity(self):
    """geom contact affinity (ngeom x 1)."""
    return util.buf_to_npy(self._ptr.contents.geom_conaffinity,
                           (self.ngeom,))

  @util.CachedProperty
  def geom_condim(self):
    """contact dimensionality (1, 3, 4, 6) (ngeom x 1)."""
    return util.buf_to_npy(self._ptr.contents.geom_condim,
                           (self.ngeom,))

  @util.CachedProperty
  def geom_bodyid(self):
    """id of geom's body (ngeom x 1)."""
    return util.buf_to_npy(self._ptr.contents.geom_bodyid,
                           (self.ngeom,))

  @util.CachedProperty
  def geom_dataid(self):
    """id of geom's mesh/hfield (-1: none) (ngeom x 1)."""
    return util.buf_to_npy(self._ptr.contents.geom_dataid,
                           (self.ngeom,))

  @util.CachedProperty
  def geom_matid(self):
    """material id for rendering (ngeom x 1)."""
    return util.buf_to_npy(self._ptr.contents.geom_matid,
                           (self.ngeom,))

  @util.CachedProperty
  def geom_group(self):
    """group for visibility (ngeom x 1)."""
    return util.buf_to_npy(self._ptr.contents.geom_group,
                           (self.ngeom,))

  @util.CachedProperty
  def geom_priority(self):
    """geom contact priority (ngeom x 1)."""
    return util.buf_to_npy(self._ptr.contents.geom_priority,
                           (self.ngeom,))

  @util.CachedProperty
  def geom_sameframe(self):
    """same as body frame (1) or iframe (2) (ngeom x 1)."""
    return util.buf_to_npy(self._ptr.contents.geom_sameframe,
                           (self.ngeom,))

  @util.CachedProperty
  def geom_solmix(self):
    """mixing coef for solref/imp in geom pair (ngeom x 1)."""
    return util.buf_to_npy(self._ptr.contents.geom_solmix,
                           (self.ngeom,))

  @util.CachedProperty
  def geom_solref(self):
    """constraint solver reference: contact (ngeom x mjNREF)."""
    return util.buf_to_npy(self._ptr.contents.geom_solref,
                           (self.ngeom, 2))

  @util.CachedProperty
  def geom_solimp(self):
    """constraint solver impedance: contact (ngeom x mjNIMP)."""
    return util.buf_to_npy(self._ptr.contents.geom_solimp,
                           (self.ngeom, 5))

  @util.CachedProperty
  def geom_size(self):
    """geom-specific size parameters (ngeom x 3)."""
    return util.buf_to_npy(self._ptr.contents.geom_size,
                           (self.ngeom, 3))

  @util.CachedProperty
  def geom_rbound(self):
    """radius of bounding sphere (ngeom x 1)."""
    return util.buf_to_npy(self._ptr.contents.geom_rbound,
                           (self.ngeom,))

  @util.CachedProperty
  def geom_pos(self):
    """local position offset rel. to body (ngeom x 3)."""
    return util.buf_to_npy(self._ptr.contents.geom_pos,
                           (self.ngeom, 3))

  @util.CachedProperty
  def geom_quat(self):
    """local orientation offset rel. to body (ngeom x 4)."""
    return util.buf_to_npy(self._ptr.contents.geom_quat,
                           (self.ngeom, 4))

  @util.CachedProperty
  def geom_friction(self):
    """friction for (slide, spin, roll) (ngeom x 3)."""
    return util.buf_to_npy(self._ptr.contents.geom_friction,
                           (self.ngeom, 3))

  @util.CachedProperty
  def geom_margin(self):
    """detect contact if dist<margin (ngeom x 1)."""
    return util.buf_to_npy(self._ptr.contents.geom_margin,
                           (self.ngeom,))

  @util.CachedProperty
  def geom_gap(self):
    """include in solver if dist<margin-gap (ngeom x 1)."""
    return util.buf_to_npy(self._ptr.contents.geom_gap,
                           (self.ngeom,))

  @util.CachedProperty
  def geom_user(self):
    """user data (ngeom x nuser_geom)."""
    return util.buf_to_npy(self._ptr.contents.geom_user,
                           (self.ngeom, self.nuser_geom))

  @util.CachedProperty
  def geom_rgba(self):
    """rgba when material is omitted (ngeom x 4)."""
    return util.buf_to_npy(self._ptr.contents.geom_rgba,
                           (self.ngeom, 4))

  @util.CachedProperty
  def site_type(self):
    """geom type for rendering (mjtGeom) (nsite x 1)."""
    return util.buf_to_npy(self._ptr.contents.site_type,
                           (self.nsite,))

  @util.CachedProperty
  def site_bodyid(self):
    """id of site's body (nsite x 1)."""
    return util.buf_to_npy(self._ptr.contents.site_bodyid,
                           (self.nsite,))

  @util.CachedProperty
  def site_matid(self):
    """material id for rendering (nsite x 1)."""
    return util.buf_to_npy(self._ptr.contents.site_matid,
                           (self.nsite,))

  @util.CachedProperty
  def site_group(self):
    """group for visibility (nsite x 1)."""
    return util.buf_to_npy(self._ptr.contents.site_group,
                           (self.nsite,))

  @util.CachedProperty
  def site_sameframe(self):
    """same as body frame (1) or iframe (2) (nsite x 1)."""
    return util.buf_to_npy(self._ptr.contents.site_sameframe,
                           (self.nsite,))

  @util.CachedProperty
  def site_size(self):
    """geom size for rendering (nsite x 3)."""
    return util.buf_to_npy(self._ptr.contents.site_size,
                           (self.nsite, 3))

  @util.CachedProperty
  def site_pos(self):
    """local position offset rel. to body (nsite x 3)."""
    return util.buf_to_npy(self._ptr.contents.site_pos,
                           (self.nsite, 3))

  @util.CachedProperty
  def site_quat(self):
    """local orientation offset rel. to body (nsite x 4)."""
    return util.buf_to_npy(self._ptr.contents.site_quat,
                           (self.nsite, 4))

  @util.CachedProperty
  def site_user(self):
    """user data (nsite x nuser_site)."""
    return util.buf_to_npy(self._ptr.contents.site_user,
                           (self.nsite, self.nuser_site))

  @util.CachedProperty
  def site_rgba(self):
    """rgba when material is omitted (nsite x 4)."""
    return util.buf_to_npy(self._ptr.contents.site_rgba,
                           (self.nsite, 4))

  @util.CachedProperty
  def cam_mode(self):
    """camera tracking mode (mjtCamLight) (ncam x 1)."""
    return util.buf_to_npy(self._ptr.contents.cam_mode,
                           (self.ncam,))

  @util.CachedProperty
  def cam_bodyid(self):
    """id of camera's body (ncam x 1)."""
    return util.buf_to_npy(self._ptr.contents.cam_bodyid,
                           (self.ncam,))

  @util.CachedProperty
  def cam_targetbodyid(self):
    """id of targeted body; -1: none (ncam x 1)."""
    return util.buf_to_npy(self._ptr.contents.cam_targetbodyid,
                           (self.ncam,))

  @util.CachedProperty
  def cam_pos(self):
    """position rel. to body frame (ncam x 3)."""
    return util.buf_to_npy(self._ptr.contents.cam_pos,
                           (self.ncam, 3))

  @util.CachedProperty
  def cam_quat(self):
    """orientation rel. to body frame (ncam x 4)."""
    return util.buf_to_npy(self._ptr.contents.cam_quat,
                           (self.ncam, 4))

  @util.CachedProperty
  def cam_poscom0(self):
    """global position rel. to sub-com in qpos0 (ncam x 3)."""
    return util.buf_to_npy(self._ptr.contents.cam_poscom0,
                           (self.ncam, 3))

  @util.CachedProperty
  def cam_pos0(self):
    """global position rel. to body in qpos0 (ncam x 3)."""
    return util.buf_to_npy(self._ptr.contents.cam_pos0,
                           (self.ncam, 3))

  @util.CachedProperty
  def cam_mat0(self):
    """global orientation in qpos0 (ncam x 9)."""
    return util.buf_to_npy(self._ptr.contents.cam_mat0,
                           (self.ncam, 9))

  @util.CachedProperty
  def cam_fovy(self):
    """y-field of view (deg) (ncam x 1)."""
    return util.buf_to_npy(self._ptr.contents.cam_fovy,
                           (self.ncam,))

  @util.CachedProperty
  def cam_ipd(self):
    """inter-pupilary distance (ncam x 1)."""
    return util.buf_to_npy(self._ptr.contents.cam_ipd,
                           (self.ncam,))

  @util.CachedProperty
  def cam_user(self):
    """user data (ncam x nuser_cam)."""
    return util.buf_to_npy(self._ptr.contents.cam_user,
                           (self.ncam, self.nuser_cam))

  @util.CachedProperty
  def light_mode(self):
    """light tracking mode (mjtCamLight) (nlight x 1)."""
    return util.buf_to_npy(self._ptr.contents.light_mode,
                           (self.nlight,))

  @util.CachedProperty
  def light_bodyid(self):
    """id of light's body (nlight x 1)."""
    return util.buf_to_npy(self._ptr.contents.light_bodyid,
                           (self.nlight,))

  @util.CachedProperty
  def light_targetbodyid(self):
    """id of targeted body; -1: none (nlight x 1)."""
    return util.buf_to_npy(self._ptr.contents.light_targetbodyid,
                           (self.nlight,))

  @util.CachedProperty
  def light_directional(self):
    """directional light (nlight x 1)."""
    return util.buf_to_npy(self._ptr.contents.light_directional,
                           (self.nlight,))

  @util.CachedProperty
  def light_castshadow(self):
    """does light cast shadows (nlight x 1)."""
    return util.buf_to_npy(self._ptr.contents.light_castshadow,
                           (self.nlight,))

  @util.CachedProperty
  def light_active(self):
    """is light on (nlight x 1)."""
    return util.buf_to_npy(self._ptr.contents.light_active,
                           (self.nlight,))

  @util.CachedProperty
  def light_pos(self):
    """position rel. to body frame (nlight x 3)."""
    return util.buf_to_npy(self._ptr.contents.light_pos,
                           (self.nlight, 3))

  @util.CachedProperty
  def light_dir(self):
    """direction rel. to body frame (nlight x 3)."""
    return util.buf_to_npy(self._ptr.contents.light_dir,
                           (self.nlight, 3))

  @util.CachedProperty
  def light_poscom0(self):
    """global position rel. to sub-com in qpos0 (nlight x 3)."""
    return util.buf_to_npy(self._ptr.contents.light_poscom0,
                           (self.nlight, 3))

  @util.CachedProperty
  def light_pos0(self):
    """global position rel. to body in qpos0 (nlight x 3)."""
    return util.buf_to_npy(self._ptr.contents.light_pos0,
                           (self.nlight, 3))

  @util.CachedProperty
  def light_dir0(self):
    """global direction in qpos0 (nlight x 3)."""
    return util.buf_to_npy(self._ptr.contents.light_dir0,
                           (self.nlight, 3))

  @util.CachedProperty
  def light_attenuation(self):
    """OpenGL attenuation (quadratic model) (nlight x 3)."""
    return util.buf_to_npy(self._ptr.contents.light_attenuation,
                           (self.nlight, 3))

  @util.CachedProperty
  def light_cutoff(self):
    """OpenGL cutoff (nlight x 1)."""
    return util.buf_to_npy(self._ptr.contents.light_cutoff,
                           (self.nlight,))

  @util.CachedProperty
  def light_exponent(self):
    """OpenGL exponent (nlight x 1)."""
    return util.buf_to_npy(self._ptr.contents.light_exponent,
                           (self.nlight,))

  @util.CachedProperty
  def light_ambient(self):
    """ambient rgb (alpha=1) (nlight x 3)."""
    return util.buf_to_npy(self._ptr.contents.light_ambient,
                           (self.nlight, 3))

  @util.CachedProperty
  def light_diffuse(self):
    """diffuse rgb (alpha=1) (nlight x 3)."""
    return util.buf_to_npy(self._ptr.contents.light_diffuse,
                           (self.nlight, 3))

  @util.CachedProperty
  def light_specular(self):
    """specular rgb (alpha=1) (nlight x 3)."""
    return util.buf_to_npy(self._ptr.contents.light_specular,
                           (self.nlight, 3))

  @util.CachedProperty
  def mesh_vertadr(self):
    """first vertex address (nmesh x 1)."""
    return util.buf_to_npy(self._ptr.contents.mesh_vertadr,
                           (self.nmesh,))

  @util.CachedProperty
  def mesh_vertnum(self):
    """number of vertices (nmesh x 1)."""
    return util.buf_to_npy(self._ptr.contents.mesh_vertnum,
                           (self.nmesh,))

  @util.CachedProperty
  def mesh_texcoordadr(self):
    """texcoord data address; -1: no texcoord (nmesh x 1)."""
    return util.buf_to_npy(self._ptr.contents.mesh_texcoordadr,
                           (self.nmesh,))

  @util.CachedProperty
  def mesh_faceadr(self):
    """first face address (nmesh x 1)."""
    return util.buf_to_npy(self._ptr.contents.mesh_faceadr,
                           (self.nmesh,))

  @util.CachedProperty
  def mesh_facenum(self):
    """number of faces (nmesh x 1)."""
    return util.buf_to_npy(self._ptr.contents.mesh_facenum,
                           (self.nmesh,))

  @util.CachedProperty
  def mesh_graphadr(self):
    """graph data address; -1: no graph (nmesh x 1)."""
    return util.buf_to_npy(self._ptr.contents.mesh_graphadr,
                           (self.nmesh,))

  @util.CachedProperty
  def mesh_vert(self):
    """vertex positions for all meshe (nmeshvert x 3)."""
    return util.buf_to_npy(self._ptr.contents.mesh_vert,
                           (self.nmeshvert, 3))

  @util.CachedProperty
  def mesh_normal(self):
    """vertex normals for all meshes (nmeshvert x 3)."""
    return util.buf_to_npy(self._ptr.contents.mesh_normal,
                           (self.nmeshvert, 3))

  @util.CachedProperty
  def mesh_texcoord(self):
    """vertex texcoords for all meshes (nmeshtexvert x 2)."""
    return util.buf_to_npy(self._ptr.contents.mesh_texcoord,
                           (self.nmeshtexvert, 2))

  @util.CachedProperty
  def mesh_face(self):
    """triangle face data (nmeshface x 3)."""
    return util.buf_to_npy(self._ptr.contents.mesh_face,
                           (self.nmeshface, 3))

  @util.CachedProperty
  def mesh_graph(self):
    """convex graph data (nmeshgraph x 1)."""
    return util.buf_to_npy(self._ptr.contents.mesh_graph,
                           (self.nmeshgraph,))

  @util.CachedProperty
  def skin_matid(self):
    """skin material id; -1: none (nskin x 1)."""
    return util.buf_to_npy(self._ptr.contents.skin_matid,
                           (self.nskin,))

  @util.CachedProperty
  def skin_rgba(self):
    """skin rgba (nskin x 4)."""
    return util.buf_to_npy(self._ptr.contents.skin_rgba,
                           (self.nskin, 4))

  @util.CachedProperty
  def skin_inflate(self):
    """inflate skin in normal direction (nskin x 1)."""
    return util.buf_to_npy(self._ptr.contents.skin_inflate,
                           (self.nskin,))

  @util.CachedProperty
  def skin_vertadr(self):
    """first vertex address (nskin x 1)."""
    return util.buf_to_npy(self._ptr.contents.skin_vertadr,
                           (self.nskin,))

  @util.CachedProperty
  def skin_vertnum(self):
    """number of vertices (nskin x 1)."""
    return util.buf_to_npy(self._ptr.contents.skin_vertnum,
                           (self.nskin,))

  @util.CachedProperty
  def skin_texcoordadr(self):
    """texcoord data address; -1: no texcoord (nskin x 1)."""
    return util.buf_to_npy(self._ptr.contents.skin_texcoordadr,
                           (self.nskin,))

  @util.CachedProperty
  def skin_faceadr(self):
    """first face address (nskin x 1)."""
    return util.buf_to_npy(self._ptr.contents.skin_faceadr,
                           (self.nskin,))

  @util.CachedProperty
  def skin_facenum(self):
    """number of faces (nskin x 1)."""
    return util.buf_to_npy(self._ptr.contents.skin_facenum,
                           (self.nskin,))

  @util.CachedProperty
  def skin_boneadr(self):
    """first bone in skin (nskin x 1)."""
    return util.buf_to_npy(self._ptr.contents.skin_boneadr,
                           (self.nskin,))

  @util.CachedProperty
  def skin_bonenum(self):
    """number of bones in skin (nskin x 1)."""
    return util.buf_to_npy(self._ptr.contents.skin_bonenum,
                           (self.nskin,))

  @util.CachedProperty
  def skin_vert(self):
    """vertex positions for all skin meshes (nskinvert x 3)."""
    return util.buf_to_npy(self._ptr.contents.skin_vert,
                           (self.nskinvert, 3))

  @util.CachedProperty
  def skin_texcoord(self):
    """vertex texcoords for all skin meshes (nskintexvert x 2)."""
    return util.buf_to_npy(self._ptr.contents.skin_texcoord,
                           (self.nskintexvert, 2))

  @util.CachedProperty
  def skin_face(self):
    """triangle faces for all skin meshes (nskinface x 3)."""
    return util.buf_to_npy(self._ptr.contents.skin_face,
                           (self.nskinface, 3))

  @util.CachedProperty
  def skin_bonevertadr(self):
    """first vertex in each bone (nskinbone x 1)."""
    return util.buf_to_npy(self._ptr.contents.skin_bonevertadr,
                           (self.nskinbone,))

  @util.CachedProperty
  def skin_bonevertnum(self):
    """number of vertices in each bone (nskinbone x 1)."""
    return util.buf_to_npy(self._ptr.contents.skin_bonevertnum,
                           (self.nskinbone,))

  @util.CachedProperty
  def skin_bonebindpos(self):
    """bind pos of each bone (nskinbone x 3)."""
    return util.buf_to_npy(self._ptr.contents.skin_bonebindpos,
                           (self.nskinbone, 3))

  @util.CachedProperty
  def skin_bonebindquat(self):
    """bind quat of each bone (nskinbone x 4)."""
    return util.buf_to_npy(self._ptr.contents.skin_bonebindquat,
                           (self.nskinbone, 4))

  @util.CachedProperty
  def skin_bonebodyid(self):
    """body id of each bone (nskinbone x 1)."""
    return util.buf_to_npy(self._ptr.contents.skin_bonebodyid,
                           (self.nskinbone,))

  @util.CachedProperty
  def skin_bonevertid(self):
    """mesh ids of vertices in each bone (nskinbonevert x 1)."""
    return util.buf_to_npy(self._ptr.contents.skin_bonevertid,
                           (self.nskinbonevert,))

  @util.CachedProperty
  def skin_bonevertweight(self):
    """weights of vertices in each bone (nskinbonevert x 1)."""
    return util.buf_to_npy(self._ptr.contents.skin_bonevertweight,
                           (self.nskinbonevert,))

  @util.CachedProperty
  def hfield_size(self):
    """(x, y, z_top, z_bottom) (nhfield x 4)."""
    return util.buf_to_npy(self._ptr.contents.hfield_size,
                           (self.nhfield, 4))

  @util.CachedProperty
  def hfield_nrow(self):
    """number of rows in grid (nhfield x 1)."""
    return util.buf_to_npy(self._ptr.contents.hfield_nrow,
                           (self.nhfield,))

  @util.CachedProperty
  def hfield_ncol(self):
    """number of columns in grid (nhfield x 1)."""
    return util.buf_to_npy(self._ptr.contents.hfield_ncol,
                           (self.nhfield,))

  @util.CachedProperty
  def hfield_adr(self):
    """address in hfield_data (nhfield x 1)."""
    return util.buf_to_npy(self._ptr.contents.hfield_adr,
                           (self.nhfield,))

  @util.CachedProperty
  def hfield_data(self):
    """elevation data (nhfielddata x 1)."""
    return util.buf_to_npy(self._ptr.contents.hfield_data,
                           (self.nhfielddata,))

  @util.CachedProperty
  def tex_type(self):
    """texture type (mjtTexture) (ntex x 1)."""
    return util.buf_to_npy(self._ptr.contents.tex_type,
                           (self.ntex,))

  @util.CachedProperty
  def tex_height(self):
    """number of rows in texture image (ntex x 1)."""
    return util.buf_to_npy(self._ptr.contents.tex_height,
                           (self.ntex,))

  @util.CachedProperty
  def tex_width(self):
    """number of columns in texture image (ntex x 1)."""
    return util.buf_to_npy(self._ptr.contents.tex_width,
                           (self.ntex,))

  @util.CachedProperty
  def tex_adr(self):
    """address in rgb (ntex x 1)."""
    return util.buf_to_npy(self._ptr.contents.tex_adr,
                           (self.ntex,))

  @util.CachedProperty
  def tex_rgb(self):
    """rgb (alpha = 1) (ntexdata x 1)."""
    return util.buf_to_npy(self._ptr.contents.tex_rgb,
                           (self.ntexdata,))

  @util.CachedProperty
  def mat_texid(self):
    """texture id; -1: none (nmat x 1)."""
    return util.buf_to_npy(self._ptr.contents.mat_texid,
                           (self.nmat,))

  @util.CachedProperty
  def mat_texuniform(self):
    """make texture cube uniform (nmat x 1)."""
    return util.buf_to_npy(self._ptr.contents.mat_texuniform,
                           (self.nmat,))

  @util.CachedProperty
  def mat_texrepeat(self):
    """texture repetition for 2d mapping (nmat x 2)."""
    return util.buf_to_npy(self._ptr.contents.mat_texrepeat,
                           (self.nmat, 2))

  @util.CachedProperty
  def mat_emission(self):
    """emission (x rgb) (nmat x 1)."""
    return util.buf_to_npy(self._ptr.contents.mat_emission,
                           (self.nmat,))

  @util.CachedProperty
  def mat_specular(self):
    """specular (x white) (nmat x 1)."""
    return util.buf_to_npy(self._ptr.contents.mat_specular,
                           (self.nmat,))

  @util.CachedProperty
  def mat_shininess(self):
    """shininess coef (nmat x 1)."""
    return util.buf_to_npy(self._ptr.contents.mat_shininess,
                           (self.nmat,))

  @util.CachedProperty
  def mat_reflectance(self):
    """reflectance (0: disable) (nmat x 1)."""
    return util.buf_to_npy(self._ptr.contents.mat_reflectance,
                           (self.nmat,))

  @util.CachedProperty
  def mat_rgba(self):
    """rgba (nmat x 4)."""
    return util.buf_to_npy(self._ptr.contents.mat_rgba,
                           (self.nmat, 4))

  @util.CachedProperty
  def pair_dim(self):
    """contact dimensionality (npair x 1)."""
    return util.buf_to_npy(self._ptr.contents.pair_dim,
                           (self.npair,))

  @util.CachedProperty
  def pair_geom1(self):
    """id of geom1 (npair x 1)."""
    return util.buf_to_npy(self._ptr.contents.pair_geom1,
                           (self.npair,))

  @util.CachedProperty
  def pair_geom2(self):
    """id of geom2 (npair x 1)."""
    return util.buf_to_npy(self._ptr.contents.pair_geom2,
                           (self.npair,))

  @util.CachedProperty
  def pair_signature(self):
    """(body1+1)<<16 + body2+1 (npair x 1)."""
    return util.buf_to_npy(self._ptr.contents.pair_signature,
                           (self.npair,))

  @util.CachedProperty
  def pair_solref(self):
    """constraint solver reference: contact (npair x mjNREF)."""
    return util.buf_to_npy(self._ptr.contents.pair_solref,
                           (self.npair, 2))

  @util.CachedProperty
  def pair_solimp(self):
    """constraint solver impedance: contact (npair x mjNIMP)."""
    return util.buf_to_npy(self._ptr.contents.pair_solimp,
                           (self.npair, 5))

  @util.CachedProperty
  def pair_margin(self):
    """detect contact if dist<margin (npair x 1)."""
    return util.buf_to_npy(self._ptr.contents.pair_margin,
                           (self.npair,))

  @util.CachedProperty
  def pair_gap(self):
    """include in solver if dist<margin-gap (npair x 1)."""
    return util.buf_to_npy(self._ptr.contents.pair_gap,
                           (self.npair,))

  @util.CachedProperty
  def pair_friction(self):
    """tangent1, 2, spin, roll1, 2 (npair x 5)."""
    return util.buf_to_npy(self._ptr.contents.pair_friction,
                           (self.npair, 5))

  @util.CachedProperty
  def exclude_signature(self):
    """(body1+1)<<16 + body2+1 (nexclude x 1)."""
    return util.buf_to_npy(self._ptr.contents.exclude_signature,
                           (self.nexclude,))

  @util.CachedProperty
  def eq_type(self):
    """constraint type (mjtEq) (neq x 1)."""
    return util.buf_to_npy(self._ptr.contents.eq_type,
                           (self.neq,))

  @util.CachedProperty
  def eq_obj1id(self):
    """id of object 1 (neq x 1)."""
    return util.buf_to_npy(self._ptr.contents.eq_obj1id,
                           (self.neq,))

  @util.CachedProperty
  def eq_obj2id(self):
    """id of object 2 (neq x 1)."""
    return util.buf_to_npy(self._ptr.contents.eq_obj2id,
                           (self.neq,))

  @util.CachedProperty
  def eq_active(self):
    """enable/disable constraint (neq x 1)."""
    return util.buf_to_npy(self._ptr.contents.eq_active,
                           (self.neq,))

  @util.CachedProperty
  def eq_solref(self):
    """constraint solver reference (neq x mjNREF)."""
    return util.buf_to_npy(self._ptr.contents.eq_solref,
                           (self.neq, 2))

  @util.CachedProperty
  def eq_solimp(self):
    """constraint solver impedance (neq x mjNIMP)."""
    return util.buf_to_npy(self._ptr.contents.eq_solimp,
                           (self.neq, 5))

  @util.CachedProperty
  def eq_data(self):
    """numeric data for constraint (neq x mjNEQDATA)."""
    return util.buf_to_npy(self._ptr.contents.eq_data,
                           (self.neq, 7))

  @util.CachedProperty
  def tendon_adr(self):
    """address of first object in tendon's path (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.tendon_adr,
                           (self.ntendon,))

  @util.CachedProperty
  def tendon_num(self):
    """number of objects in tendon's path (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.tendon_num,
                           (self.ntendon,))

  @util.CachedProperty
  def tendon_matid(self):
    """material id for rendering (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.tendon_matid,
                           (self.ntendon,))

  @util.CachedProperty
  def tendon_group(self):
    """group for visibility (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.tendon_group,
                           (self.ntendon,))

  @util.CachedProperty
  def tendon_limited(self):
    """does tendon have length limits (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.tendon_limited,
                           (self.ntendon,))

  @util.CachedProperty
  def tendon_width(self):
    """width for rendering (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.tendon_width,
                           (self.ntendon,))

  @util.CachedProperty
  def tendon_solref_lim(self):
    """constraint solver reference: limit (ntendon x mjNREF)."""
    return util.buf_to_npy(self._ptr.contents.tendon_solref_lim,
                           (self.ntendon, 2))

  @util.CachedProperty
  def tendon_solimp_lim(self):
    """constraint solver impedance: limit (ntendon x mjNIMP)."""
    return util.buf_to_npy(self._ptr.contents.tendon_solimp_lim,
                           (self.ntendon, 5))

  @util.CachedProperty
  def tendon_solref_fri(self):
    """constraint solver reference: friction (ntendon x mjNREF)."""
    return util.buf_to_npy(self._ptr.contents.tendon_solref_fri,
                           (self.ntendon, 2))

  @util.CachedProperty
  def tendon_solimp_fri(self):
    """constraint solver impedance: friction (ntendon x mjNIMP)."""
    return util.buf_to_npy(self._ptr.contents.tendon_solimp_fri,
                           (self.ntendon, 5))

  @util.CachedProperty
  def tendon_range(self):
    """tendon length limits (ntendon x 2)."""
    return util.buf_to_npy(self._ptr.contents.tendon_range,
                           (self.ntendon, 2))

  @util.CachedProperty
  def tendon_margin(self):
    """min distance for limit detection (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.tendon_margin,
                           (self.ntendon,))

  @util.CachedProperty
  def tendon_stiffness(self):
    """stiffness coefficient (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.tendon_stiffness,
                           (self.ntendon,))

  @util.CachedProperty
  def tendon_damping(self):
    """damping coefficient (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.tendon_damping,
                           (self.ntendon,))

  @util.CachedProperty
  def tendon_frictionloss(self):
    """loss due to friction (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.tendon_frictionloss,
                           (self.ntendon,))

  @util.CachedProperty
  def tendon_lengthspring(self):
    """tendon length in qpos_spring (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.tendon_lengthspring,
                           (self.ntendon,))

  @util.CachedProperty
  def tendon_length0(self):
    """tendon length in qpos0 (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.tendon_length0,
                           (self.ntendon,))

  @util.CachedProperty
  def tendon_invweight0(self):
    """inv. weight in qpos0 (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.tendon_invweight0,
                           (self.ntendon,))

  @util.CachedProperty
  def tendon_user(self):
    """user data (ntendon x nuser_tendon)."""
    return util.buf_to_npy(self._ptr.contents.tendon_user,
                           (self.ntendon, self.nuser_tendon))

  @util.CachedProperty
  def tendon_rgba(self):
    """rgba when material is omitted (ntendon x 4)."""
    return util.buf_to_npy(self._ptr.contents.tendon_rgba,
                           (self.ntendon, 4))

  @util.CachedProperty
  def wrap_type(self):
    """wrap object type (mjtWrap) (nwrap x 1)."""
    return util.buf_to_npy(self._ptr.contents.wrap_type,
                           (self.nwrap,))

  @util.CachedProperty
  def wrap_objid(self):
    """object id: geom, site, joint (nwrap x 1)."""
    return util.buf_to_npy(self._ptr.contents.wrap_objid,
                           (self.nwrap,))

  @util.CachedProperty
  def wrap_prm(self):
    """divisor, joint coef, or site id (nwrap x 1)."""
    return util.buf_to_npy(self._ptr.contents.wrap_prm,
                           (self.nwrap,))

  @util.CachedProperty
  def actuator_trntype(self):
    """transmission type (mjtTrn) (nu x 1)."""
    return util.buf_to_npy(self._ptr.contents.actuator_trntype,
                           (self.nu,))

  @util.CachedProperty
  def actuator_dyntype(self):
    """dynamics type (mjtDyn) (nu x 1)."""
    return util.buf_to_npy(self._ptr.contents.actuator_dyntype,
                           (self.nu,))

  @util.CachedProperty
  def actuator_gaintype(self):
    """gain type (mjtGain) (nu x 1)."""
    return util.buf_to_npy(self._ptr.contents.actuator_gaintype,
                           (self.nu,))

  @util.CachedProperty
  def actuator_biastype(self):
    """bias type (mjtBias) (nu x 1)."""
    return util.buf_to_npy(self._ptr.contents.actuator_biastype,
                           (self.nu,))

  @util.CachedProperty
  def actuator_trnid(self):
    """transmission id: joint, tendon, site (nu x 2)."""
    return util.buf_to_npy(self._ptr.contents.actuator_trnid,
                           (self.nu, 2))

  @util.CachedProperty
  def actuator_group(self):
    """group for visibility (nu x 1)."""
    return util.buf_to_npy(self._ptr.contents.actuator_group,
                           (self.nu,))

  @util.CachedProperty
  def actuator_ctrllimited(self):
    """is control limited (nu x 1)."""
    return util.buf_to_npy(self._ptr.contents.actuator_ctrllimited,
                           (self.nu,))

  @util.CachedProperty
  def actuator_forcelimited(self):
    """is force limited (nu x 1)."""
    return util.buf_to_npy(self._ptr.contents.actuator_forcelimited,
                           (self.nu,))

  @util.CachedProperty
  def actuator_dynprm(self):
    """dynamics parameters (nu x mjNDYN)."""
    return util.buf_to_npy(self._ptr.contents.actuator_dynprm,
                           (self.nu, 10))

  @util.CachedProperty
  def actuator_gainprm(self):
    """gain parameters (nu x mjNGAIN)."""
    return util.buf_to_npy(self._ptr.contents.actuator_gainprm,
                           (self.nu, 10))

  @util.CachedProperty
  def actuator_biasprm(self):
    """bias parameters (nu x mjNBIAS)."""
    return util.buf_to_npy(self._ptr.contents.actuator_biasprm,
                           (self.nu, 10))

  @util.CachedProperty
  def actuator_ctrlrange(self):
    """range of controls (nu x 2)."""
    return util.buf_to_npy(self._ptr.contents.actuator_ctrlrange,
                           (self.nu, 2))

  @util.CachedProperty
  def actuator_forcerange(self):
    """range of forces (nu x 2)."""
    return util.buf_to_npy(self._ptr.contents.actuator_forcerange,
                           (self.nu, 2))

  @util.CachedProperty
  def actuator_gear(self):
    """scale length and transmitted force (nu x 6)."""
    return util.buf_to_npy(self._ptr.contents.actuator_gear,
                           (self.nu, 6))

  @util.CachedProperty
  def actuator_cranklength(self):
    """crank length for slider-crank (nu x 1)."""
    return util.buf_to_npy(self._ptr.contents.actuator_cranklength,
                           (self.nu,))

  @util.CachedProperty
  def actuator_acc0(self):
    """acceleration from unit force in qpos0 (nu x 1)."""
    return util.buf_to_npy(self._ptr.contents.actuator_acc0,
                           (self.nu,))

  @util.CachedProperty
  def actuator_length0(self):
    """actuator length in qpos0 (nu x 1)."""
    return util.buf_to_npy(self._ptr.contents.actuator_length0,
                           (self.nu,))

  @util.CachedProperty
  def actuator_lengthrange(self):
    """feasible actuator length range (nu x 2)."""
    return util.buf_to_npy(self._ptr.contents.actuator_lengthrange,
                           (self.nu, 2))

  @util.CachedProperty
  def actuator_user(self):
    """user data (nu x nuser_actuator)."""
    return util.buf_to_npy(self._ptr.contents.actuator_user,
                           (self.nu, self.nuser_actuator))

  @util.CachedProperty
  def sensor_type(self):
    """sensor type (mjtSensor) (nsensor x 1)."""
    return util.buf_to_npy(self._ptr.contents.sensor_type,
                           (self.nsensor,))

  @util.CachedProperty
  def sensor_datatype(self):
    """numeric data type (mjtDataType) (nsensor x 1)."""
    return util.buf_to_npy(self._ptr.contents.sensor_datatype,
                           (self.nsensor,))

  @util.CachedProperty
  def sensor_needstage(self):
    """required compute stage (mjtStage) (nsensor x 1)."""
    return util.buf_to_npy(self._ptr.contents.sensor_needstage,
                           (self.nsensor,))

  @util.CachedProperty
  def sensor_objtype(self):
    """type of sensorized object (mjtObj) (nsensor x 1)."""
    return util.buf_to_npy(self._ptr.contents.sensor_objtype,
                           (self.nsensor,))

  @util.CachedProperty
  def sensor_objid(self):
    """id of sensorized object (nsensor x 1)."""
    return util.buf_to_npy(self._ptr.contents.sensor_objid,
                           (self.nsensor,))

  @util.CachedProperty
  def sensor_dim(self):
    """number of scalar outputs (nsensor x 1)."""
    return util.buf_to_npy(self._ptr.contents.sensor_dim,
                           (self.nsensor,))

  @util.CachedProperty
  def sensor_adr(self):
    """address in sensor array (nsensor x 1)."""
    return util.buf_to_npy(self._ptr.contents.sensor_adr,
                           (self.nsensor,))

  @util.CachedProperty
  def sensor_cutoff(self):
    """cutoff for real and positive; 0: ignore (nsensor x 1)."""
    return util.buf_to_npy(self._ptr.contents.sensor_cutoff,
                           (self.nsensor,))

  @util.CachedProperty
  def sensor_noise(self):
    """noise standard deviation (nsensor x 1)."""
    return util.buf_to_npy(self._ptr.contents.sensor_noise,
                           (self.nsensor,))

  @util.CachedProperty
  def sensor_user(self):
    """user data (nsensor x nuser_sensor)."""
    return util.buf_to_npy(self._ptr.contents.sensor_user,
                           (self.nsensor, self.nuser_sensor))

  @util.CachedProperty
  def numeric_adr(self):
    """address of field in numeric_data (nnumeric x 1)."""
    return util.buf_to_npy(self._ptr.contents.numeric_adr,
                           (self.nnumeric,))

  @util.CachedProperty
  def numeric_size(self):
    """size of numeric field (nnumeric x 1)."""
    return util.buf_to_npy(self._ptr.contents.numeric_size,
                           (self.nnumeric,))

  @util.CachedProperty
  def numeric_data(self):
    """array of all numeric fields (nnumericdata x 1)."""
    return util.buf_to_npy(self._ptr.contents.numeric_data,
                           (self.nnumericdata,))

  @util.CachedProperty
  def text_adr(self):
    """address of text in text_data (ntext x 1)."""
    return util.buf_to_npy(self._ptr.contents.text_adr,
                           (self.ntext,))

  @util.CachedProperty
  def text_size(self):
    """size of text field (strlen+1) (ntext x 1)."""
    return util.buf_to_npy(self._ptr.contents.text_size,
                           (self.ntext,))

  @property
  def text_data(self):
    """array of all text fields (0-terminated) (ntextdata x 1)."""
    return self._ptr.contents.text_data

  @text_data.setter
  def text_data(self, value):
    self._ptr.contents.text_data = value

  @util.CachedProperty
  def tuple_adr(self):
    """address of text in text_data (ntuple x 1)."""
    return util.buf_to_npy(self._ptr.contents.tuple_adr,
                           (self.ntuple,))

  @util.CachedProperty
  def tuple_size(self):
    """number of objects in tuple (ntuple x 1)."""
    return util.buf_to_npy(self._ptr.contents.tuple_size,
                           (self.ntuple,))

  @util.CachedProperty
  def tuple_objtype(self):
    """array of object types in all tuples (ntupledata x 1)."""
    return util.buf_to_npy(self._ptr.contents.tuple_objtype,
                           (self.ntupledata,))

  @util.CachedProperty
  def tuple_objid(self):
    """array of object ids in all tuples (ntupledata x 1)."""
    return util.buf_to_npy(self._ptr.contents.tuple_objid,
                           (self.ntupledata,))

  @util.CachedProperty
  def tuple_objprm(self):
    """array of object params in all tuples (ntupledata x 1)."""
    return util.buf_to_npy(self._ptr.contents.tuple_objprm,
                           (self.ntupledata,))

  @util.CachedProperty
  def key_time(self):
    """key time (nkey x 1)."""
    return util.buf_to_npy(self._ptr.contents.key_time,
                           (self.nkey,))

  @util.CachedProperty
  def key_qpos(self):
    """key position (nkey x nq)."""
    return util.buf_to_npy(self._ptr.contents.key_qpos,
                           (self.nkey, self.nq))

  @util.CachedProperty
  def key_qvel(self):
    """key velocity (nkey x nv)."""
    return util.buf_to_npy(self._ptr.contents.key_qvel,
                           (self.nkey, self.nv))

  @util.CachedProperty
  def key_act(self):
    """key activation (nkey x na)."""
    return util.buf_to_npy(self._ptr.contents.key_act,
                           (self.nkey, self.na))

  @util.CachedProperty
  def name_bodyadr(self):
    """body name pointers (nbody x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_bodyadr,
                           (self.nbody,))

  @util.CachedProperty
  def name_jntadr(self):
    """joint name pointers (njnt x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_jntadr,
                           (self.njnt,))

  @util.CachedProperty
  def name_geomadr(self):
    """geom name pointers (ngeom x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_geomadr,
                           (self.ngeom,))

  @util.CachedProperty
  def name_siteadr(self):
    """site name pointers (nsite x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_siteadr,
                           (self.nsite,))

  @util.CachedProperty
  def name_camadr(self):
    """camera name pointers (ncam x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_camadr,
                           (self.ncam,))

  @util.CachedProperty
  def name_lightadr(self):
    """light name pointers (nlight x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_lightadr,
                           (self.nlight,))

  @util.CachedProperty
  def name_meshadr(self):
    """mesh name pointers (nmesh x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_meshadr,
                           (self.nmesh,))

  @util.CachedProperty
  def name_skinadr(self):
    """skin name pointers (nskin x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_skinadr,
                           (self.nskin,))

  @util.CachedProperty
  def name_hfieldadr(self):
    """hfield name pointers (nhfield x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_hfieldadr,
                           (self.nhfield,))

  @util.CachedProperty
  def name_texadr(self):
    """texture name pointers (ntex x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_texadr,
                           (self.ntex,))

  @util.CachedProperty
  def name_matadr(self):
    """material name pointers (nmat x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_matadr,
                           (self.nmat,))

  @util.CachedProperty
  def name_pairadr(self):
    """geom pair name pointers (npair x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_pairadr,
                           (self.npair,))

  @util.CachedProperty
  def name_excludeadr(self):
    """exclude name pointers (nexclude x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_excludeadr,
                           (self.nexclude,))

  @util.CachedProperty
  def name_eqadr(self):
    """equality constraint name pointers (neq x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_eqadr,
                           (self.neq,))

  @util.CachedProperty
  def name_tendonadr(self):
    """tendon name pointers (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_tendonadr,
                           (self.ntendon,))

  @util.CachedProperty
  def name_actuatoradr(self):
    """actuator name pointers (nu x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_actuatoradr,
                           (self.nu,))

  @util.CachedProperty
  def name_sensoradr(self):
    """sensor name pointers (nsensor x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_sensoradr,
                           (self.nsensor,))

  @util.CachedProperty
  def name_numericadr(self):
    """numeric name pointers (nnumeric x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_numericadr,
                           (self.nnumeric,))

  @util.CachedProperty
  def name_textadr(self):
    """text name pointers (ntext x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_textadr,
                           (self.ntext,))

  @util.CachedProperty
  def name_tupleadr(self):
    """tuple name pointers (ntuple x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_tupleadr,
                           (self.ntuple,))

  @util.CachedProperty
  def name_keyadr(self):
    """keyframe name pointers (nkey x 1)."""
    return util.buf_to_npy(self._ptr.contents.name_keyadr,
                           (self.nkey,))

  @property
  def names(self):
    """names of all objects, 0-terminated (nnames x 1)."""
    return self._ptr.contents.names

  @names.setter
  def names(self, value):
    self._ptr.contents.names = value


class MjContactWrapper(util.WrapperBase):
  """result of collision detection functions."""

  @property
  def dist(self):
    """distance between nearest points; neg: penetration."""
    return self._ptr.contents.dist

  @dist.setter
  def dist(self, value):
    self._ptr.contents.dist = value

  @util.CachedProperty
  def pos(self):
    """position of contact point: midpoint between geoms."""
    return util.buf_to_npy(self._ptr.contents.pos, (3,))

  @util.CachedProperty
  def frame(self):
    """normal is in [0-2]."""
    return util.buf_to_npy(self._ptr.contents.frame, (9,))

  @property
  def includemargin(self):
    """include if dist<includemargin=margin-gap."""
    return self._ptr.contents.includemargin

  @includemargin.setter
  def includemargin(self, value):
    self._ptr.contents.includemargin = value

  @util.CachedProperty
  def friction(self):
    """tangent1, 2, spin, roll1, 2."""
    return util.buf_to_npy(self._ptr.contents.friction, (5,))

  @util.CachedProperty
  def solref(self):
    """constraint solver reference."""
    return util.buf_to_npy(self._ptr.contents.solref, (2,))

  @util.CachedProperty
  def solimp(self):
    """constraint solver impedance."""
    return util.buf_to_npy(self._ptr.contents.solimp, (5,))

  @property
  def mu(self):
    """friction of regularized cone, set by mj_makeConstraint."""
    return self._ptr.contents.mu

  @mu.setter
  def mu(self, value):
    self._ptr.contents.mu = value

  @util.CachedProperty
  def H(self):
    """cone Hessian, set by mj_updateConstraint."""
    return util.buf_to_npy(self._ptr.contents.H, (36,))

  @property
  def dim(self):
    """contact space dimensionality: 1, 3, 4 or 6."""
    return self._ptr.contents.dim

  @dim.setter
  def dim(self, value):
    self._ptr.contents.dim = value

  @property
  def geom1(self):
    """id of geom 1."""
    return self._ptr.contents.geom1

  @geom1.setter
  def geom1(self, value):
    self._ptr.contents.geom1 = value

  @property
  def geom2(self):
    """id of geom 2."""
    return self._ptr.contents.geom2

  @geom2.setter
  def geom2(self, value):
    self._ptr.contents.geom2 = value

  @property
  def exclude(self):
    """0: include, 1: in gap, 2: fused, 3: equality, 4: no dofs."""
    return self._ptr.contents.exclude

  @exclude.setter
  def exclude(self, value):
    self._ptr.contents.exclude = value

  @property
  def efc_address(self):
    """address in efc; -1: not included, -2-i: distance constraint i."""
    return self._ptr.contents.efc_address

  @efc_address.setter
  def efc_address(self, value):
    self._ptr.contents.efc_address = value


class MjWarningStatWrapper(util.WrapperBase):
  """warning statistics."""

  @property
  def lastinfo(self):
    """info from last warning."""
    return self._ptr.contents.lastinfo

  @lastinfo.setter
  def lastinfo(self, value):
    self._ptr.contents.lastinfo = value

  @property
  def number(self):
    """how many times was warning raised."""
    return self._ptr.contents.number

  @number.setter
  def number(self, value):
    self._ptr.contents.number = value


class MjTimerStatWrapper(util.WrapperBase):
  """timer statistics."""

  @property
  def duration(self):
    """cumulative duration."""
    return self._ptr.contents.duration

  @duration.setter
  def duration(self, value):
    self._ptr.contents.duration = value

  @property
  def number(self):
    """how many times was timer called."""
    return self._ptr.contents.number

  @number.setter
  def number(self, value):
    self._ptr.contents.number = value


class MjSolverStatWrapper(util.WrapperBase):
  """per-iteration solver statistics."""

  @property
  def improvement(self):
    """cost reduction, scaled by 1/trace(M(qpos0))."""
    return self._ptr.contents.improvement

  @improvement.setter
  def improvement(self, value):
    self._ptr.contents.improvement = value

  @property
  def gradient(self):
    """gradient norm (primal only, scaled)."""
    return self._ptr.contents.gradient

  @gradient.setter
  def gradient(self, value):
    self._ptr.contents.gradient = value

  @property
  def lineslope(self):
    """slope in linesearch."""
    return self._ptr.contents.lineslope

  @lineslope.setter
  def lineslope(self, value):
    self._ptr.contents.lineslope = value

  @property
  def nactive(self):
    """number of active constraints."""
    return self._ptr.contents.nactive

  @nactive.setter
  def nactive(self, value):
    self._ptr.contents.nactive = value

  @property
  def nchange(self):
    """number of constraint state changes."""
    return self._ptr.contents.nchange

  @nchange.setter
  def nchange(self, value):
    self._ptr.contents.nchange = value

  @property
  def neval(self):
    """number of cost evaluations in line search."""
    return self._ptr.contents.neval

  @neval.setter
  def neval(self, value):
    self._ptr.contents.neval = value

  @property
  def nupdate(self):
    """number of Cholesky updates in line search."""
    return self._ptr.contents.nupdate

  @nupdate.setter
  def nupdate(self, value):
    self._ptr.contents.nupdate = value


class MjDataWrapper(util.WrapperBase):
  """<no header comment found>."""

  @property
  def nstack(self):
    """number of mjtNums that can fit in stack."""
    return self._ptr.contents.nstack

  @nstack.setter
  def nstack(self, value):
    self._ptr.contents.nstack = value

  @property
  def nbuffer(self):
    """size of main buffer in bytes."""
    return self._ptr.contents.nbuffer

  @nbuffer.setter
  def nbuffer(self, value):
    self._ptr.contents.nbuffer = value

  @property
  def pstack(self):
    """first available mjtNum address in stack."""
    return self._ptr.contents.pstack

  @pstack.setter
  def pstack(self, value):
    self._ptr.contents.pstack = value

  @property
  def maxuse_stack(self):
    """maximum stack allocation."""
    return self._ptr.contents.maxuse_stack

  @maxuse_stack.setter
  def maxuse_stack(self, value):
    self._ptr.contents.maxuse_stack = value

  @property
  def maxuse_con(self):
    """maximum number of contacts."""
    return self._ptr.contents.maxuse_con

  @maxuse_con.setter
  def maxuse_con(self, value):
    self._ptr.contents.maxuse_con = value

  @property
  def maxuse_efc(self):
    """maximum number of scalar constraints."""
    return self._ptr.contents.maxuse_efc

  @maxuse_efc.setter
  def maxuse_efc(self, value):
    self._ptr.contents.maxuse_efc = value

  @util.CachedProperty
  def warning(self):
    """warning statistics."""
    return util.buf_to_npy(self._ptr.contents.warning, (8,))

  @util.CachedProperty
  def timer(self):
    """timer statistics."""
    return util.buf_to_npy(self._ptr.contents.timer, (13,))

  @util.CachedProperty
  def solver(self):
    """solver statistics per iteration."""
    return util.buf_to_npy(self._ptr.contents.solver, (1000,))

  @property
  def solver_iter(self):
    """number of solver iterations."""
    return self._ptr.contents.solver_iter

  @solver_iter.setter
  def solver_iter(self, value):
    self._ptr.contents.solver_iter = value

  @property
  def solver_nnz(self):
    """number of non-zeros in Hessian or efc_AR."""
    return self._ptr.contents.solver_nnz

  @solver_nnz.setter
  def solver_nnz(self, value):
    self._ptr.contents.solver_nnz = value

  @util.CachedProperty
  def solver_fwdinv(self):
    """forward-inverse comparison: qfrc, efc."""
    return util.buf_to_npy(self._ptr.contents.solver_fwdinv, (2,))

  @property
  def ne(self):
    """number of equality constraints."""
    return self._ptr.contents.ne

  @ne.setter
  def ne(self, value):
    self._ptr.contents.ne = value

  @property
  def nf(self):
    """number of friction constraints."""
    return self._ptr.contents.nf

  @nf.setter
  def nf(self, value):
    self._ptr.contents.nf = value

  @property
  def nefc(self):
    """number of constraints."""
    return self._ptr.contents.nefc

  @nefc.setter
  def nefc(self, value):
    self._ptr.contents.nefc = value

  @property
  def ncon(self):
    """number of detected contacts."""
    return self._ptr.contents.ncon

  @ncon.setter
  def ncon(self, value):
    self._ptr.contents.ncon = value

  @property
  def time(self):
    """simulation time."""
    return self._ptr.contents.time

  @time.setter
  def time(self, value):
    self._ptr.contents.time = value

  @util.CachedProperty
  def energy(self):
    """potential, kinetic energy."""
    return util.buf_to_npy(self._ptr.contents.energy, (2,))

  @property
  def buffer_(self):
    """main buffer; all pointers point in it (nbuffer bytes)."""
    return self._ptr.contents.buffer_

  @buffer_.setter
  def buffer_(self, value):
    self._ptr.contents.buffer_ = value

  @util.CachedProperty
  def stack(self):
    """stack buffer (nstack mjtNums)."""
    return util.buf_to_npy(self._ptr.contents.stack,
                           (self.nstack,))

  @util.CachedProperty
  def qpos(self):
    """position (nq x 1)."""
    return util.buf_to_npy(self._ptr.contents.qpos,
                           (self._model.nq,))

  @util.CachedProperty
  def qvel(self):
    """velocity (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.qvel,
                           (self._model.nv,))

  @util.CachedProperty
  def act(self):
    """actuator activation (na x 1)."""
    return util.buf_to_npy(self._ptr.contents.act,
                           (self._model.na,))

  @util.CachedProperty
  def qacc_warmstart(self):
    """acceleration used for warmstart (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.qacc_warmstart,
                           (self._model.nv,))

  @util.CachedProperty
  def ctrl(self):
    """control (nu x 1)."""
    return util.buf_to_npy(self._ptr.contents.ctrl,
                           (self._model.nu,))

  @util.CachedProperty
  def qfrc_applied(self):
    """applied generalized force (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.qfrc_applied,
                           (self._model.nv,))

  @util.CachedProperty
  def xfrc_applied(self):
    """applied Cartesian force/torque (nbody x 6)."""
    return util.buf_to_npy(self._ptr.contents.xfrc_applied,
                           (self._model.nbody, 6))

  @util.CachedProperty
  def qacc(self):
    """acceleration (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.qacc,
                           (self._model.nv,))

  @util.CachedProperty
  def act_dot(self):
    """time-derivative of actuator activation (na x 1)."""
    return util.buf_to_npy(self._ptr.contents.act_dot,
                           (self._model.na,))

  @util.CachedProperty
  def mocap_pos(self):
    """positions of mocap bodies (nmocap x 3)."""
    return util.buf_to_npy(self._ptr.contents.mocap_pos,
                           (self._model.nmocap, 3))

  @util.CachedProperty
  def mocap_quat(self):
    """orientations of mocap bodies (nmocap x 4)."""
    return util.buf_to_npy(self._ptr.contents.mocap_quat,
                           (self._model.nmocap, 4))

  @util.CachedProperty
  def userdata(self):
    """user data, not touched by engine (nuserdata x 1)."""
    return util.buf_to_npy(self._ptr.contents.userdata,
                           (self._model.nuserdata,))

  @util.CachedProperty
  def sensordata(self):
    """sensor data array (nsensordata x 1)."""
    return util.buf_to_npy(self._ptr.contents.sensordata,
                           (self._model.nsensordata,))

  @util.CachedProperty
  def xpos(self):
    """Cartesian position of body frame (nbody x 3)."""
    return util.buf_to_npy(self._ptr.contents.xpos,
                           (self._model.nbody, 3))

  @util.CachedProperty
  def xquat(self):
    """Cartesian orientation of body frame (nbody x 4)."""
    return util.buf_to_npy(self._ptr.contents.xquat,
                           (self._model.nbody, 4))

  @util.CachedProperty
  def xmat(self):
    """Cartesian orientation of body frame (nbody x 9)."""
    return util.buf_to_npy(self._ptr.contents.xmat,
                           (self._model.nbody, 9))

  @util.CachedProperty
  def xipos(self):
    """Cartesian position of body com (nbody x 3)."""
    return util.buf_to_npy(self._ptr.contents.xipos,
                           (self._model.nbody, 3))

  @util.CachedProperty
  def ximat(self):
    """Cartesian orientation of body inertia (nbody x 9)."""
    return util.buf_to_npy(self._ptr.contents.ximat,
                           (self._model.nbody, 9))

  @util.CachedProperty
  def xanchor(self):
    """Cartesian position of joint anchor (njnt x 3)."""
    return util.buf_to_npy(self._ptr.contents.xanchor,
                           (self._model.njnt, 3))

  @util.CachedProperty
  def xaxis(self):
    """Cartesian joint axis (njnt x 3)."""
    return util.buf_to_npy(self._ptr.contents.xaxis,
                           (self._model.njnt, 3))

  @util.CachedProperty
  def geom_xpos(self):
    """Cartesian geom position (ngeom x 3)."""
    return util.buf_to_npy(self._ptr.contents.geom_xpos,
                           (self._model.ngeom, 3))

  @util.CachedProperty
  def geom_xmat(self):
    """Cartesian geom orientation (ngeom x 9)."""
    return util.buf_to_npy(self._ptr.contents.geom_xmat,
                           (self._model.ngeom, 9))

  @util.CachedProperty
  def site_xpos(self):
    """Cartesian site position (nsite x 3)."""
    return util.buf_to_npy(self._ptr.contents.site_xpos,
                           (self._model.nsite, 3))

  @util.CachedProperty
  def site_xmat(self):
    """Cartesian site orientation (nsite x 9)."""
    return util.buf_to_npy(self._ptr.contents.site_xmat,
                           (self._model.nsite, 9))

  @util.CachedProperty
  def cam_xpos(self):
    """Cartesian camera position (ncam x 3)."""
    return util.buf_to_npy(self._ptr.contents.cam_xpos,
                           (self._model.ncam, 3))

  @util.CachedProperty
  def cam_xmat(self):
    """Cartesian camera orientation (ncam x 9)."""
    return util.buf_to_npy(self._ptr.contents.cam_xmat,
                           (self._model.ncam, 9))

  @util.CachedProperty
  def light_xpos(self):
    """Cartesian light position (nlight x 3)."""
    return util.buf_to_npy(self._ptr.contents.light_xpos,
                           (self._model.nlight, 3))

  @util.CachedProperty
  def light_xdir(self):
    """Cartesian light direction (nlight x 3)."""
    return util.buf_to_npy(self._ptr.contents.light_xdir,
                           (self._model.nlight, 3))

  @util.CachedProperty
  def subtree_com(self):
    """center of mass of each subtree (nbody x 3)."""
    return util.buf_to_npy(self._ptr.contents.subtree_com,
                           (self._model.nbody, 3))

  @util.CachedProperty
  def cdof(self):
    """com-based motion axis of each dof (nv x 6)."""
    return util.buf_to_npy(self._ptr.contents.cdof,
                           (self._model.nv, 6))

  @util.CachedProperty
  def cinert(self):
    """com-based body inertia and mass (nbody x 10)."""
    return util.buf_to_npy(self._ptr.contents.cinert,
                           (self._model.nbody, 10))

  @util.CachedProperty
  def ten_wrapadr(self):
    """start address of tendon's path (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.ten_wrapadr,
                           (self._model.ntendon,))

  @util.CachedProperty
  def ten_wrapnum(self):
    """number of wrap points in path (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.ten_wrapnum,
                           (self._model.ntendon,))

  @util.CachedProperty
  def ten_J_rownnz(self):
    """number of non-zeros in Jacobian row (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.ten_J_rownnz,
                           (self._model.ntendon,))

  @util.CachedProperty
  def ten_J_rowadr(self):
    """row start address in colind array (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.ten_J_rowadr,
                           (self._model.ntendon,))

  @util.CachedProperty
  def ten_J_colind(self):
    """column indices in sparse Jacobian (ntendon x nv)."""
    return util.buf_to_npy(self._ptr.contents.ten_J_colind,
                           (self._model.ntendon, self._model.nv))

  @util.CachedProperty
  def ten_length(self):
    """tendon lengths (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.ten_length,
                           (self._model.ntendon,))

  @util.CachedProperty
  def ten_J(self):
    """tendon Jacobian (ntendon x nv)."""
    return util.buf_to_npy(self._ptr.contents.ten_J,
                           (self._model.ntendon, self._model.nv))

  @util.CachedProperty
  def wrap_obj(self):
    """geom id; -1: site; -2: pulley (nwrap*2 x 1)."""
    return util.buf_to_npy(self._ptr.contents.wrap_obj,
                           (self._model.nwrap, 2))

  @util.CachedProperty
  def wrap_xpos(self):
    """Cartesian 3D points in all path (nwrap*2 x 3)."""
    return util.buf_to_npy(self._ptr.contents.wrap_xpos,
                           (self._model.nwrap, 6))

  @util.CachedProperty
  def actuator_length(self):
    """actuator lengths (nu x 1)."""
    return util.buf_to_npy(self._ptr.contents.actuator_length,
                           (self._model.nu,))

  @util.CachedProperty
  def actuator_moment(self):
    """actuator moments (nu x nv)."""
    return util.buf_to_npy(self._ptr.contents.actuator_moment,
                           (self._model.nu, self._model.nv))

  @util.CachedProperty
  def crb(self):
    """com-based composite inertia and mass (nbody x 10)."""
    return util.buf_to_npy(self._ptr.contents.crb,
                           (self._model.nbody, 10))

  @util.CachedProperty
  def qM(self):
    """total inertia (nM x 1)."""
    return util.buf_to_npy(self._ptr.contents.qM,
                           (self._model.nM,))

  @util.CachedProperty
  def qLD(self):
    """L'*D*L factorization of M (nM x 1)."""
    return util.buf_to_npy(self._ptr.contents.qLD,
                           (self._model.nM,))

  @util.CachedProperty
  def qLDiagInv(self):
    """1/diag(D) (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.qLDiagInv,
                           (self._model.nv,))

  @util.CachedProperty
  def qLDiagSqrtInv(self):
    """1/sqrt(diag(D)) (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.qLDiagSqrtInv,
                           (self._model.nv,))

  @property
  def contact(self):
    """list of all detected contacts (nconmax x 1)."""
    return self._ptr.contents.contact

  @contact.setter
  def contact(self, value):
    self._ptr.contents.contact = value

  @util.CachedProperty
  def efc_type(self):
    """constraint type (mjtConstraint) (njmax x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_type,
                           (self._model.njmax,))

  @util.CachedProperty
  def efc_id(self):
    """id of object of specified type (njmax x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_id,
                           (self._model.njmax,))

  @util.CachedProperty
  def efc_J_rownnz(self):
    """number of non-zeros in Jacobian row (njmax x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_J_rownnz,
                           (self._model.njmax,))

  @util.CachedProperty
  def efc_J_rowadr(self):
    """row start address in colind array (njmax x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_J_rowadr,
                           (self._model.njmax,))

  @util.CachedProperty
  def efc_J_rowsuper(self):
    """number of subsequent rows in supernode (njmax x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_J_rowsuper,
                           (self._model.njmax,))

  @util.CachedProperty
  def efc_J_colind(self):
    """column indices in Jacobian (njmax x nv)."""
    return util.buf_to_npy(self._ptr.contents.efc_J_colind,
                           (self._model.njmax, self._model.nv))

  @util.CachedProperty
  def efc_JT_rownnz(self):
    """number of non-zeros in Jacobian row T (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_JT_rownnz,
                           (self._model.nv,))

  @util.CachedProperty
  def efc_JT_rowadr(self):
    """row start address in colind array T (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_JT_rowadr,
                           (self._model.nv,))

  @util.CachedProperty
  def efc_JT_rowsuper(self):
    """number of subsequent rows in supernode T (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_JT_rowsuper,
                           (self._model.nv,))

  @util.CachedProperty
  def efc_JT_colind(self):
    """column indices in Jacobian T (nv x njmax)."""
    return util.buf_to_npy(self._ptr.contents.efc_JT_colind,
                           (self._model.nv, self._model.njmax))

  @util.CachedProperty
  def efc_J(self):
    """constraint Jacobian (njmax x nv)."""
    return util.buf_to_npy(self._ptr.contents.efc_J,
                           (self._model.njmax, self._model.nv))

  @util.CachedProperty
  def efc_JT(self):
    """constraint Jacobian transposed (nv x njmax)."""
    return util.buf_to_npy(self._ptr.contents.efc_JT,
                           (self._model.nv, self._model.njmax))

  @util.CachedProperty
  def efc_pos(self):
    """constraint position (equality, contact) (njmax x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_pos,
                           (self._model.njmax,))

  @util.CachedProperty
  def efc_margin(self):
    """inclusion margin (contact) (njmax x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_margin,
                           (self._model.njmax,))

  @util.CachedProperty
  def efc_frictionloss(self):
    """frictionloss (friction) (njmax x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_frictionloss,
                           (self._model.njmax,))

  @util.CachedProperty
  def efc_diagApprox(self):
    """approximation to diagonal of A (njmax x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_diagApprox,
                           (self._model.njmax,))

  @util.CachedProperty
  def efc_KBIP(self):
    """stiffness, damping, impedance, imp' (njmax x 4)."""
    return util.buf_to_npy(self._ptr.contents.efc_KBIP,
                           (self._model.njmax, 4))

  @util.CachedProperty
  def efc_D(self):
    """constraint mass (njmax x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_D,
                           (self._model.njmax,))

  @util.CachedProperty
  def efc_R(self):
    """inverse constraint mass (njmax x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_R,
                           (self._model.njmax,))

  @util.CachedProperty
  def efc_AR_rownnz(self):
    """number of non-zeros in AR (njmax x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_AR_rownnz,
                           (self._model.njmax,))

  @util.CachedProperty
  def efc_AR_rowadr(self):
    """row start address in colind array (njmax x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_AR_rowadr,
                           (self._model.njmax,))

  @util.CachedProperty
  def efc_AR_colind(self):
    """column indices in sparse AR (njmax x njmax)."""
    return util.buf_to_npy(self._ptr.contents.efc_AR_colind,
                           (self._model.njmax, self._model.njmax))

  @util.CachedProperty
  def efc_AR(self):
    """J*inv(M)*J' + R (njmax x njmax)."""
    return util.buf_to_npy(self._ptr.contents.efc_AR,
                           (self._model.njmax, self._model.njmax))

  @util.CachedProperty
  def ten_velocity(self):
    """tendon velocities (ntendon x 1)."""
    return util.buf_to_npy(self._ptr.contents.ten_velocity,
                           (self._model.ntendon,))

  @util.CachedProperty
  def actuator_velocity(self):
    """actuator velocities (nu x 1)."""
    return util.buf_to_npy(self._ptr.contents.actuator_velocity,
                           (self._model.nu,))

  @util.CachedProperty
  def cvel(self):
    """com-based velocity [3D rot; 3D tran] (nbody x 6)."""
    return util.buf_to_npy(self._ptr.contents.cvel,
                           (self._model.nbody, 6))

  @util.CachedProperty
  def cdof_dot(self):
    """time-derivative of cdof (nv x 6)."""
    return util.buf_to_npy(self._ptr.contents.cdof_dot,
                           (self._model.nv, 6))

  @util.CachedProperty
  def qfrc_bias(self):
    """C(qpos,qvel) (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.qfrc_bias,
                           (self._model.nv,))

  @util.CachedProperty
  def qfrc_passive(self):
    """passive force (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.qfrc_passive,
                           (self._model.nv,))

  @util.CachedProperty
  def efc_vel(self):
    """velocity in constraint space: J*qvel (njmax x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_vel,
                           (self._model.njmax,))

  @util.CachedProperty
  def efc_aref(self):
    """reference pseudo-acceleration (njmax x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_aref,
                           (self._model.njmax,))

  @util.CachedProperty
  def subtree_linvel(self):
    """linear velocity of subtree com (nbody x 3)."""
    return util.buf_to_npy(self._ptr.contents.subtree_linvel,
                           (self._model.nbody, 3))

  @util.CachedProperty
  def subtree_angmom(self):
    """angular momentum about subtree com (nbody x 3)."""
    return util.buf_to_npy(self._ptr.contents.subtree_angmom,
                           (self._model.nbody, 3))

  @util.CachedProperty
  def actuator_force(self):
    """actuator force in actuation space (nu x 1)."""
    return util.buf_to_npy(self._ptr.contents.actuator_force,
                           (self._model.nu,))

  @util.CachedProperty
  def qfrc_actuator(self):
    """actuator force (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.qfrc_actuator,
                           (self._model.nv,))

  @util.CachedProperty
  def qfrc_unc(self):
    """net unconstrained force (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.qfrc_unc,
                           (self._model.nv,))

  @util.CachedProperty
  def qacc_unc(self):
    """unconstrained acceleration (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.qacc_unc,
                           (self._model.nv,))

  @util.CachedProperty
  def efc_b(self):
    """linear cost term: J*qacc_unc - aref (njmax x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_b,
                           (self._model.njmax,))

  @util.CachedProperty
  def efc_force(self):
    """constraint force in constraint space (njmax x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_force,
                           (self._model.njmax,))

  @util.CachedProperty
  def efc_state(self):
    """constraint state (mjtConstraintState) (njmax x 1)."""
    return util.buf_to_npy(self._ptr.contents.efc_state,
                           (self._model.njmax,))

  @util.CachedProperty
  def qfrc_constraint(self):
    """constraint force (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.qfrc_constraint,
                           (self._model.nv,))

  @util.CachedProperty
  def qfrc_inverse(self):
    """net external force; should equal: (nv x 1)."""
    return util.buf_to_npy(self._ptr.contents.qfrc_inverse,
                           (self._model.nv,))

  @util.CachedProperty
  def cacc(self):
    """com-based acceleration (nbody x 6)."""
    return util.buf_to_npy(self._ptr.contents.cacc,
                           (self._model.nbody, 6))

  @util.CachedProperty
  def cfrc_int(self):
    """com-based interaction force with parent (nbody x 6)."""
    return util.buf_to_npy(self._ptr.contents.cfrc_int,
                           (self._model.nbody, 6))

  @util.CachedProperty
  def cfrc_ext(self):
    """com-based external force on body (nbody x 6)."""
    return util.buf_to_npy(self._ptr.contents.cfrc_ext,
                           (self._model.nbody, 6))


class MjrRectWrapper(util.WrapperBase):
  """OpenGL rectangle."""

  @property
  def left(self):
    """left (usually 0)."""
    return self._ptr.contents.left

  @left.setter
  def left(self, value):
    self._ptr.contents.left = value

  @property
  def bottom(self):
    """bottom (usually 0)."""
    return self._ptr.contents.bottom

  @bottom.setter
  def bottom(self, value):
    self._ptr.contents.bottom = value

  @property
  def width(self):
    """width (usually buffer width)."""
    return self._ptr.contents.width

  @width.setter
  def width(self, value):
    self._ptr.contents.width = value

  @property
  def height(self):
    """height (usually buffer height)."""
    return self._ptr.contents.height

  @height.setter
  def height(self, value):
    self._ptr.contents.height = value


class MjrContextWrapper(util.WrapperBase):
  """custom OpenGL context."""

  @property
  def lineWidth(self):
    """line width for wireframe rendering."""
    return self._ptr.contents.lineWidth

  @lineWidth.setter
  def lineWidth(self, value):
    self._ptr.contents.lineWidth = value

  @property
  def shadowClip(self):
    """clipping radius for directional lights."""
    return self._ptr.contents.shadowClip

  @shadowClip.setter
  def shadowClip(self, value):
    self._ptr.contents.shadowClip = value

  @property
  def shadowScale(self):
    """fraction of light cutoff for spot lights."""
    return self._ptr.contents.shadowScale

  @shadowScale.setter
  def shadowScale(self, value):
    self._ptr.contents.shadowScale = value

  @property
  def fogStart(self):
    """fog start = stat.extent * vis.map.fogstart."""
    return self._ptr.contents.fogStart

  @fogStart.setter
  def fogStart(self, value):
    self._ptr.contents.fogStart = value

  @property
  def fogEnd(self):
    """fog end = stat.extent * vis.map.fogend."""
    return self._ptr.contents.fogEnd

  @fogEnd.setter
  def fogEnd(self, value):
    self._ptr.contents.fogEnd = value

  @util.CachedProperty
  def fogRGBA(self):
    """fog rgba."""
    return util.buf_to_npy(self._ptr.contents.fogRGBA, (4,))

  @property
  def shadowSize(self):
    """size of shadow map texture."""
    return self._ptr.contents.shadowSize

  @shadowSize.setter
  def shadowSize(self, value):
    self._ptr.contents.shadowSize = value

  @property
  def offWidth(self):
    """width of offscreen buffer."""
    return self._ptr.contents.offWidth

  @offWidth.setter
  def offWidth(self, value):
    self._ptr.contents.offWidth = value

  @property
  def offHeight(self):
    """height of offscreen buffer."""
    return self._ptr.contents.offHeight

  @offHeight.setter
  def offHeight(self, value):
    self._ptr.contents.offHeight = value

  @property
  def offSamples(self):
    """number of offscreen buffer multisamples."""
    return self._ptr.contents.offSamples

  @offSamples.setter
  def offSamples(self, value):
    self._ptr.contents.offSamples = value

  @property
  def fontScale(self):
    """font scale."""
    return self._ptr.contents.fontScale

  @fontScale.setter
  def fontScale(self, value):
    self._ptr.contents.fontScale = value

  @util.CachedProperty
  def auxWidth(self):
    """auxiliary buffer width."""
    return util.buf_to_npy(self._ptr.contents.auxWidth, (10,))

  @util.CachedProperty
  def auxHeight(self):
    """auxiliary buffer height."""
    return util.buf_to_npy(self._ptr.contents.auxHeight, (10,))

  @util.CachedProperty
  def auxSamples(self):
    """auxiliary buffer multisamples."""
    return util.buf_to_npy(self._ptr.contents.auxSamples, (10,))

  @property
  def offFBO(self):
    """offscreen framebuffer object."""
    return self._ptr.contents.offFBO

  @offFBO.setter
  def offFBO(self, value):
    self._ptr.contents.offFBO = value

  @property
  def offFBO_r(self):
    """offscreen framebuffer for resolving multisamples."""
    return self._ptr.contents.offFBO_r

  @offFBO_r.setter
  def offFBO_r(self, value):
    self._ptr.contents.offFBO_r = value

  @property
  def offColor(self):
    """offscreen color buffer."""
    return self._ptr.contents.offColor

  @offColor.setter
  def offColor(self, value):
    self._ptr.contents.offColor = value

  @property
  def offColor_r(self):
    """offscreen color buffer for resolving multisamples."""
    return self._ptr.contents.offColor_r

  @offColor_r.setter
  def offColor_r(self, value):
    self._ptr.contents.offColor_r = value

  @property
  def offDepthStencil(self):
    """offscreen depth and stencil buffer."""
    return self._ptr.contents.offDepthStencil

  @offDepthStencil.setter
  def offDepthStencil(self, value):
    self._ptr.contents.offDepthStencil = value

  @property
  def offDepthStencil_r(self):
    """offscreen depth and stencil buffer for resolving multisamples."""
    return self._ptr.contents.offDepthStencil_r

  @offDepthStencil_r.setter
  def offDepthStencil_r(self, value):
    self._ptr.contents.offDepthStencil_r = value

  @property
  def shadowFBO(self):
    """shadow map framebuffer object."""
    return self._ptr.contents.shadowFBO

  @shadowFBO.setter
  def shadowFBO(self, value):
    self._ptr.contents.shadowFBO = value

  @property
  def shadowTex(self):
    """shadow map texture."""
    return self._ptr.contents.shadowTex

  @shadowTex.setter
  def shadowTex(self, value):
    self._ptr.contents.shadowTex = value

  @util.CachedProperty
  def auxFBO(self):
    """auxiliary framebuffer object."""
    return util.buf_to_npy(self._ptr.contents.auxFBO, (10,))

  @util.CachedProperty
  def auxFBO_r(self):
    """auxiliary framebuffer object for resolving."""
    return util.buf_to_npy(self._ptr.contents.auxFBO_r, (10,))

  @util.CachedProperty
  def auxColor(self):
    """auxiliary color buffer."""
    return util.buf_to_npy(self._ptr.contents.auxColor, (10,))

  @util.CachedProperty
  def auxColor_r(self):
    """auxiliary color buffer for resolving."""
    return util.buf_to_npy(self._ptr.contents.auxColor_r, (10,))

  @property
  def ntexture(self):
    """number of allocated textures."""
    return self._ptr.contents.ntexture

  @ntexture.setter
  def ntexture(self, value):
    self._ptr.contents.ntexture = value

  @util.CachedProperty
  def textureType(self):
    """type of texture (mjtTexture)."""
    return util.buf_to_npy(self._ptr.contents.textureType, (100,))

  @util.CachedProperty
  def texture(self):
    """texture names."""
    return util.buf_to_npy(self._ptr.contents.texture, (100,))

  @property
  def basePlane(self):
    """all planes from model."""
    return self._ptr.contents.basePlane

  @basePlane.setter
  def basePlane(self, value):
    self._ptr.contents.basePlane = value

  @property
  def baseMesh(self):
    """all meshes from model."""
    return self._ptr.contents.baseMesh

  @baseMesh.setter
  def baseMesh(self, value):
    self._ptr.contents.baseMesh = value

  @property
  def baseHField(self):
    """all hfields from model."""
    return self._ptr.contents.baseHField

  @baseHField.setter
  def baseHField(self, value):
    self._ptr.contents.baseHField = value

  @property
  def baseBuiltin(self):
    """all buildin geoms, with quality from model."""
    return self._ptr.contents.baseBuiltin

  @baseBuiltin.setter
  def baseBuiltin(self, value):
    self._ptr.contents.baseBuiltin = value

  @property
  def baseFontNormal(self):
    """normal font."""
    return self._ptr.contents.baseFontNormal

  @baseFontNormal.setter
  def baseFontNormal(self, value):
    self._ptr.contents.baseFontNormal = value

  @property
  def baseFontShadow(self):
    """shadow font."""
    return self._ptr.contents.baseFontShadow

  @baseFontShadow.setter
  def baseFontShadow(self, value):
    self._ptr.contents.baseFontShadow = value

  @property
  def baseFontBig(self):
    """big font."""
    return self._ptr.contents.baseFontBig

  @baseFontBig.setter
  def baseFontBig(self, value):
    self._ptr.contents.baseFontBig = value

  @property
  def rangePlane(self):
    """all planes from model."""
    return self._ptr.contents.rangePlane

  @rangePlane.setter
  def rangePlane(self, value):
    self._ptr.contents.rangePlane = value

  @property
  def rangeMesh(self):
    """all meshes from model."""
    return self._ptr.contents.rangeMesh

  @rangeMesh.setter
  def rangeMesh(self, value):
    self._ptr.contents.rangeMesh = value

  @property
  def rangeHField(self):
    """all hfields from model."""
    return self._ptr.contents.rangeHField

  @rangeHField.setter
  def rangeHField(self, value):
    self._ptr.contents.rangeHField = value

  @property
  def rangeBuiltin(self):
    """all builtin geoms, with quality from model."""
    return self._ptr.contents.rangeBuiltin

  @rangeBuiltin.setter
  def rangeBuiltin(self, value):
    self._ptr.contents.rangeBuiltin = value

  @property
  def rangeFont(self):
    """all characters in font."""
    return self._ptr.contents.rangeFont

  @rangeFont.setter
  def rangeFont(self, value):
    self._ptr.contents.rangeFont = value

  @property
  def nskin(self):
    """number of skins."""
    return self._ptr.contents.nskin

  @nskin.setter
  def nskin(self, value):
    self._ptr.contents.nskin = value

  @property
  def skinvertVBO(self):
    """skin vertex position VBOs."""
    return self._ptr.contents.skinvertVBO

  @skinvertVBO.setter
  def skinvertVBO(self, value):
    self._ptr.contents.skinvertVBO = value

  @property
  def skinnormalVBO(self):
    """skin vertex normal VBOs."""
    return self._ptr.contents.skinnormalVBO

  @skinnormalVBO.setter
  def skinnormalVBO(self, value):
    self._ptr.contents.skinnormalVBO = value

  @property
  def skintexcoordVBO(self):
    """skin vertex texture coordinate VBOs."""
    return self._ptr.contents.skintexcoordVBO

  @skintexcoordVBO.setter
  def skintexcoordVBO(self, value):
    self._ptr.contents.skintexcoordVBO = value

  @property
  def skinfaceVBO(self):
    """skin face index VBOs."""
    return self._ptr.contents.skinfaceVBO

  @skinfaceVBO.setter
  def skinfaceVBO(self, value):
    self._ptr.contents.skinfaceVBO = value

  @util.CachedProperty
  def charWidth(self):
    """character widths: normal and shadow."""
    return util.buf_to_npy(self._ptr.contents.charWidth, (127,))

  @util.CachedProperty
  def charWidthBig(self):
    """chacarter widths: big."""
    return util.buf_to_npy(self._ptr.contents.charWidthBig, (127,))

  @property
  def charHeight(self):
    """character heights: normal and shadow."""
    return self._ptr.contents.charHeight

  @charHeight.setter
  def charHeight(self, value):
    self._ptr.contents.charHeight = value

  @property
  def charHeightBig(self):
    """character heights: big."""
    return self._ptr.contents.charHeightBig

  @charHeightBig.setter
  def charHeightBig(self, value):
    self._ptr.contents.charHeightBig = value

  @property
  def glewInitialized(self):
    """is glew initialized."""
    return self._ptr.contents.glewInitialized

  @glewInitialized.setter
  def glewInitialized(self, value):
    self._ptr.contents.glewInitialized = value

  @property
  def windowAvailable(self):
    """is default/window framebuffer available."""
    return self._ptr.contents.windowAvailable

  @windowAvailable.setter
  def windowAvailable(self, value):
    self._ptr.contents.windowAvailable = value

  @property
  def windowSamples(self):
    """number of samples for default/window framebuffer."""
    return self._ptr.contents.windowSamples

  @windowSamples.setter
  def windowSamples(self, value):
    self._ptr.contents.windowSamples = value

  @property
  def windowStereo(self):
    """is stereo available for default/window framebuffer."""
    return self._ptr.contents.windowStereo

  @windowStereo.setter
  def windowStereo(self, value):
    self._ptr.contents.windowStereo = value

  @property
  def windowDoublebuffer(self):
    """is default/window framebuffer double buffered."""
    return self._ptr.contents.windowDoublebuffer

  @windowDoublebuffer.setter
  def windowDoublebuffer(self, value):
    self._ptr.contents.windowDoublebuffer = value

  @property
  def currentBuffer(self):
    """currently active framebuffer: mjFB_WINDOW or mjFB_OFFSCREEN."""
    return self._ptr.contents.currentBuffer

  @currentBuffer.setter
  def currentBuffer(self, value):
    self._ptr.contents.currentBuffer = value


class MjuiStateWrapper(util.WrapperBase):
  """mouse and keyboard state."""

  @property
  def nrect(self):
    """number of rectangles used."""
    return self._ptr.contents.nrect

  @nrect.setter
  def nrect(self, value):
    self._ptr.contents.nrect = value

  @util.CachedProperty
  def rect(self):
    """rectangles (index 0: entire window)."""
    return util.buf_to_npy(self._ptr.contents.rect, (15,))

  @property
  def userdata(self):
    """pointer to user data (for callbacks)."""
    return self._ptr.contents.userdata

  @userdata.setter
  def userdata(self, value):
    self._ptr.contents.userdata = value

  @property
  def type_(self):
    """(type mjtEvent)."""
    return self._ptr.contents.type_

  @type_.setter
  def type_(self, value):
    self._ptr.contents.type_ = value

  @property
  def left(self):
    """is left button down."""
    return self._ptr.contents.left

  @left.setter
  def left(self, value):
    self._ptr.contents.left = value

  @property
  def right(self):
    """is right button down."""
    return self._ptr.contents.right

  @right.setter
  def right(self, value):
    self._ptr.contents.right = value

  @property
  def middle(self):
    """is middle button down."""
    return self._ptr.contents.middle

  @middle.setter
  def middle(self, value):
    self._ptr.contents.middle = value

  @property
  def doubleclick(self):
    """is last press a double click."""
    return self._ptr.contents.doubleclick

  @doubleclick.setter
  def doubleclick(self, value):
    self._ptr.contents.doubleclick = value

  @property
  def button(self):
    """which button was pressed (mjtButton)."""
    return self._ptr.contents.button

  @button.setter
  def button(self, value):
    self._ptr.contents.button = value

  @property
  def buttontime(self):
    """time of last button press."""
    return self._ptr.contents.buttontime

  @buttontime.setter
  def buttontime(self, value):
    self._ptr.contents.buttontime = value

  @property
  def x(self):
    """x position."""
    return self._ptr.contents.x

  @x.setter
  def x(self, value):
    self._ptr.contents.x = value

  @property
  def y(self):
    """y position."""
    return self._ptr.contents.y

  @y.setter
  def y(self, value):
    self._ptr.contents.y = value

  @property
  def dx(self):
    """x displacement."""
    return self._ptr.contents.dx

  @dx.setter
  def dx(self, value):
    self._ptr.contents.dx = value

  @property
  def dy(self):
    """y displacement."""
    return self._ptr.contents.dy

  @dy.setter
  def dy(self, value):
    self._ptr.contents.dy = value

  @property
  def sx(self):
    """x scroll."""
    return self._ptr.contents.sx

  @sx.setter
  def sx(self, value):
    self._ptr.contents.sx = value

  @property
  def sy(self):
    """y scroll."""
    return self._ptr.contents.sy

  @sy.setter
  def sy(self, value):
    self._ptr.contents.sy = value

  @property
  def control(self):
    """is control down."""
    return self._ptr.contents.control

  @control.setter
  def control(self, value):
    self._ptr.contents.control = value

  @property
  def shift(self):
    """is shift down."""
    return self._ptr.contents.shift

  @shift.setter
  def shift(self, value):
    self._ptr.contents.shift = value

  @property
  def alt(self):
    """is alt down."""
    return self._ptr.contents.alt

  @alt.setter
  def alt(self, value):
    self._ptr.contents.alt = value

  @property
  def key(self):
    """which key was pressed."""
    return self._ptr.contents.key

  @key.setter
  def key(self, value):
    self._ptr.contents.key = value

  @property
  def keytime(self):
    """time of last key press."""
    return self._ptr.contents.keytime

  @keytime.setter
  def keytime(self, value):
    self._ptr.contents.keytime = value

  @property
  def mouserect(self):
    """which rectangle contains mouse."""
    return self._ptr.contents.mouserect

  @mouserect.setter
  def mouserect(self, value):
    self._ptr.contents.mouserect = value

  @property
  def dragrect(self):
    """which rectangle is dragged with mouse."""
    return self._ptr.contents.dragrect

  @dragrect.setter
  def dragrect(self, value):
    self._ptr.contents.dragrect = value

  @property
  def dragbutton(self):
    """which button started drag (mjtButton)."""
    return self._ptr.contents.dragbutton

  @dragbutton.setter
  def dragbutton(self, value):
    self._ptr.contents.dragbutton = value


class MjuiThemeSpacingWrapper(util.WrapperBase):
  """UI visualization theme spacing."""

  @property
  def total(self):
    """total width."""
    return self._ptr.contents.total

  @total.setter
  def total(self, value):
    self._ptr.contents.total = value

  @property
  def scroll(self):
    """scrollbar width."""
    return self._ptr.contents.scroll

  @scroll.setter
  def scroll(self, value):
    self._ptr.contents.scroll = value

  @property
  def label(self):
    """label width."""
    return self._ptr.contents.label

  @label.setter
  def label(self, value):
    self._ptr.contents.label = value

  @property
  def section(self):
    """section gap."""
    return self._ptr.contents.section

  @section.setter
  def section(self, value):
    self._ptr.contents.section = value

  @property
  def itemside(self):
    """item side gap."""
    return self._ptr.contents.itemside

  @itemside.setter
  def itemside(self, value):
    self._ptr.contents.itemside = value

  @property
  def itemmid(self):
    """item middle gap."""
    return self._ptr.contents.itemmid

  @itemmid.setter
  def itemmid(self, value):
    self._ptr.contents.itemmid = value

  @property
  def itemver(self):
    """item vertical gap."""
    return self._ptr.contents.itemver

  @itemver.setter
  def itemver(self, value):
    self._ptr.contents.itemver = value

  @property
  def texthor(self):
    """text horizontal gap."""
    return self._ptr.contents.texthor

  @texthor.setter
  def texthor(self, value):
    self._ptr.contents.texthor = value

  @property
  def textver(self):
    """text vertical gap."""
    return self._ptr.contents.textver

  @textver.setter
  def textver(self, value):
    self._ptr.contents.textver = value

  @property
  def linescroll(self):
    """number of pixels to scroll."""
    return self._ptr.contents.linescroll

  @linescroll.setter
  def linescroll(self, value):
    self._ptr.contents.linescroll = value

  @property
  def samples(self):
    """number of multisamples."""
    return self._ptr.contents.samples

  @samples.setter
  def samples(self, value):
    self._ptr.contents.samples = value


class MjuiThemeColorWrapper(util.WrapperBase):
  """UI visualization theme color."""

  @util.CachedProperty
  def master(self):
    """master background."""
    return util.buf_to_npy(self._ptr.contents.master, (3,))

  @util.CachedProperty
  def thumb(self):
    """scrollbar thumb."""
    return util.buf_to_npy(self._ptr.contents.thumb, (3,))

  @util.CachedProperty
  def secttitle(self):
    """section title."""
    return util.buf_to_npy(self._ptr.contents.secttitle, (3,))

  @util.CachedProperty
  def sectfont(self):
    """section font."""
    return util.buf_to_npy(self._ptr.contents.sectfont, (3,))

  @util.CachedProperty
  def sectsymbol(self):
    """section symbol."""
    return util.buf_to_npy(self._ptr.contents.sectsymbol, (3,))

  @util.CachedProperty
  def sectpane(self):
    """section pane."""
    return util.buf_to_npy(self._ptr.contents.sectpane, (3,))

  @util.CachedProperty
  def shortcut(self):
    """shortcut background."""
    return util.buf_to_npy(self._ptr.contents.shortcut, (3,))

  @util.CachedProperty
  def fontactive(self):
    """font active."""
    return util.buf_to_npy(self._ptr.contents.fontactive, (3,))

  @util.CachedProperty
  def fontinactive(self):
    """font inactive."""
    return util.buf_to_npy(self._ptr.contents.fontinactive, (3,))

  @util.CachedProperty
  def decorinactive(self):
    """decor inactive."""
    return util.buf_to_npy(self._ptr.contents.decorinactive, (3,))

  @util.CachedProperty
  def decorinactive2(self):
    """inactive slider color 2."""
    return util.buf_to_npy(self._ptr.contents.decorinactive2, (3,))

  @util.CachedProperty
  def button(self):
    """button."""
    return util.buf_to_npy(self._ptr.contents.button, (3,))

  @util.CachedProperty
  def check(self):
    """check."""
    return util.buf_to_npy(self._ptr.contents.check, (3,))

  @util.CachedProperty
  def radio(self):
    """radio."""
    return util.buf_to_npy(self._ptr.contents.radio, (3,))

  @util.CachedProperty
  def select(self):
    """select."""
    return util.buf_to_npy(self._ptr.contents.select, (3,))

  @util.CachedProperty
  def select2(self):
    """select pane."""
    return util.buf_to_npy(self._ptr.contents.select2, (3,))

  @util.CachedProperty
  def slider(self):
    """slider."""
    return util.buf_to_npy(self._ptr.contents.slider, (3,))

  @util.CachedProperty
  def slider2(self):
    """slider color 2."""
    return util.buf_to_npy(self._ptr.contents.slider2, (3,))

  @util.CachedProperty
  def edit(self):
    """edit."""
    return util.buf_to_npy(self._ptr.contents.edit, (3,))

  @util.CachedProperty
  def edit2(self):
    """edit invalid."""
    return util.buf_to_npy(self._ptr.contents.edit2, (3,))

  @util.CachedProperty
  def cursor(self):
    """edit cursor."""
    return util.buf_to_npy(self._ptr.contents.cursor, (3,))


class SingleWrapper(util.WrapperBase):
  """<no header comment found>."""

  @property
  def modifier(self):
    """0: none, 1: control, 2: shift; 4: alt."""
    return self._ptr.contents.modifier

  @modifier.setter
  def modifier(self, value):
    self._ptr.contents.modifier = value

  @property
  def shortcut(self):
    """shortcut key; 0: undefined."""
    return self._ptr.contents.shortcut

  @shortcut.setter
  def shortcut(self, value):
    self._ptr.contents.shortcut = value


class MultiWrapper(util.WrapperBase):
  """<no header comment found>."""

  @property
  def nelem(self):
    """number of elements in group."""
    return self._ptr.contents.nelem

  @nelem.setter
  def nelem(self, value):
    self._ptr.contents.nelem = value

  @property
  def name(self):
    """element names."""
    return self._ptr.contents.name


class SliderWrapper(util.WrapperBase):
  """<no header comment found>."""

  @util.CachedProperty
  def range_(self):
    """slider range."""
    return util.buf_to_npy(self._ptr.contents.range_, (2,))

  @property
  def divisions(self):
    """number of range divisions."""
    return self._ptr.contents.divisions

  @divisions.setter
  def divisions(self, value):
    self._ptr.contents.divisions = value


class EditWrapper(util.WrapperBase):
  """<no header comment found>."""

  @property
  def nelem(self):
    """number of elements in list."""
    return self._ptr.contents.nelem

  @nelem.setter
  def nelem(self, value):
    self._ptr.contents.nelem = value

  @util.CachedProperty
  def range_(self):
    """element range (min>=max: ignore)."""
    return util.buf_to_npy(self._ptr.contents.range_, (5, 2))


class MjuiItemWrapper(util.WrapperBase):
  """UI item."""

  @property
  def type_(self):
    """type (mjtItem)."""
    return self._ptr.contents.type_

  @type_.setter
  def type_(self, value):
    self._ptr.contents.type_ = value

  @property
  def name(self):
    """name."""
    return self._ptr.contents.name

  @property
  def state(self):
    """0: disable, 1: enable, 2+: use predicate."""
    return self._ptr.contents.state

  @state.setter
  def state(self, value):
    self._ptr.contents.state = value

  @property
  def pdata(self):
    """data pointer (type-specific)."""
    return self._ptr.contents.pdata

  @pdata.setter
  def pdata(self, value):
    self._ptr.contents.pdata = value

  @property
  def sectionid(self):
    """id of section containing item."""
    return self._ptr.contents.sectionid

  @sectionid.setter
  def sectionid(self, value):
    self._ptr.contents.sectionid = value

  @property
  def itemid(self):
    """id of item within section."""
    return self._ptr.contents.itemid

  @itemid.setter
  def itemid(self, value):
    self._ptr.contents.itemid = value

  @util.CachedProperty
  def single(self):
    """<no header comment found>."""
    return SingleWrapper(ctypes.pointer(self._ptr.contents.single))

  @util.CachedProperty
  def multi(self):
    """<no header comment found>."""
    return MultiWrapper(ctypes.pointer(self._ptr.contents.multi))

  @util.CachedProperty
  def slider(self):
    """<no header comment found>."""
    return SliderWrapper(ctypes.pointer(self._ptr.contents.slider))

  @util.CachedProperty
  def edit(self):
    """<no header comment found>."""
    return EditWrapper(ctypes.pointer(self._ptr.contents.edit))

  @util.CachedProperty
  def rect(self):
    """rectangle occupied by item."""
    return MjrRectWrapper(ctypes.pointer(self._ptr.contents.rect))


class MjuiSectionWrapper(util.WrapperBase):
  """UI section."""

  @property
  def name(self):
    """name."""
    return self._ptr.contents.name

  @property
  def state(self):
    """0: closed, 1: open."""
    return self._ptr.contents.state

  @state.setter
  def state(self, value):
    self._ptr.contents.state = value

  @property
  def modifier(self):
    """0: none, 1: control, 2: shift; 4: alt."""
    return self._ptr.contents.modifier

  @modifier.setter
  def modifier(self, value):
    self._ptr.contents.modifier = value

  @property
  def shortcut(self):
    """shortcut key; 0: undefined."""
    return self._ptr.contents.shortcut

  @shortcut.setter
  def shortcut(self, value):
    self._ptr.contents.shortcut = value

  @property
  def nitem(self):
    """number of items in use."""
    return self._ptr.contents.nitem

  @nitem.setter
  def nitem(self, value):
    self._ptr.contents.nitem = value

  @util.CachedProperty
  def item(self):
    """preallocated array of items."""
    return util.buf_to_npy(self._ptr.contents.item, (80,))

  @util.CachedProperty
  def rtitle(self):
    """rectangle occupied by title."""
    return MjrRectWrapper(ctypes.pointer(self._ptr.contents.rtitle))

  @util.CachedProperty
  def rcontent(self):
    """rectangle occupied by content."""
    return MjrRectWrapper(ctypes.pointer(self._ptr.contents.rcontent))


class MjUIWrapper(util.WrapperBase):
  """entire UI."""

  @util.CachedProperty
  def spacing(self):
    """UI theme spacing."""
    return MjuiThemeSpacingWrapper(ctypes.pointer(self._ptr.contents.spacing))

  @util.CachedProperty
  def color(self):
    """UI theme color."""
    return MjuiThemeColorWrapper(ctypes.pointer(self._ptr.contents.color))

  @property
  def predicate(self):
    if self._ptr.contents.predicate.value:
      return mjfItemEnable(self._ptr.contents.predicate.value)
    else:
      return None

  @predicate.setter
  def predicate(self, value):
    new_func_ptr, wrapped_pyfunc = util.cast_func_to_c_void_p(
        value, mjfItemEnable)
    # Prevents wrapped_pyfunc from being inadvertently garbage collected.
    self._ptr.contents.predicate._wrapped_pyfunc = wrapped_pyfunc
    self._ptr.contents.predicate.value = new_func_ptr.value


  @property
  def userdata(self):
    """pointer to user data (passed to predicate)."""
    return self._ptr.contents.userdata

  @userdata.setter
  def userdata(self, value):
    self._ptr.contents.userdata = value

  @property
  def rectid(self):
    """index of this ui rectangle in mjuiState."""
    return self._ptr.contents.rectid

  @rectid.setter
  def rectid(self, value):
    self._ptr.contents.rectid = value

  @property
  def auxid(self):
    """aux buffer index of this ui."""
    return self._ptr.contents.auxid

  @auxid.setter
  def auxid(self, value):
    self._ptr.contents.auxid = value

  @property
  def radiocol(self):
    """number of radio columns (0 defaults to 2)."""
    return self._ptr.contents.radiocol

  @radiocol.setter
  def radiocol(self, value):
    self._ptr.contents.radiocol = value

  @property
  def width(self):
    """width."""
    return self._ptr.contents.width

  @width.setter
  def width(self, value):
    self._ptr.contents.width = value

  @property
  def height(self):
    """current heigth."""
    return self._ptr.contents.height

  @height.setter
  def height(self, value):
    self._ptr.contents.height = value

  @property
  def maxheight(self):
    """height when all sections open."""
    return self._ptr.contents.maxheight

  @maxheight.setter
  def maxheight(self, value):
    self._ptr.contents.maxheight = value

  @property
  def scroll(self):
    """scroll from top of UI."""
    return self._ptr.contents.scroll

  @scroll.setter
  def scroll(self, value):
    self._ptr.contents.scroll = value

  @property
  def mousesect(self):
    """0: none, -1: scroll, otherwise 1+section."""
    return self._ptr.contents.mousesect

  @mousesect.setter
  def mousesect(self, value):
    self._ptr.contents.mousesect = value

  @property
  def mouseitem(self):
    """item within section."""
    return self._ptr.contents.mouseitem

  @mouseitem.setter
  def mouseitem(self, value):
    self._ptr.contents.mouseitem = value

  @property
  def mousehelp(self):
    """help button down: print shortcuts."""
    return self._ptr.contents.mousehelp

  @mousehelp.setter
  def mousehelp(self, value):
    self._ptr.contents.mousehelp = value

  @property
  def editsect(self):
    """0: none, otherwise 1+section."""
    return self._ptr.contents.editsect

  @editsect.setter
  def editsect(self, value):
    self._ptr.contents.editsect = value

  @property
  def edititem(self):
    """item within section."""
    return self._ptr.contents.edititem

  @edititem.setter
  def edititem(self, value):
    self._ptr.contents.edititem = value

  @property
  def editcursor(self):
    """cursor position."""
    return self._ptr.contents.editcursor

  @editcursor.setter
  def editcursor(self, value):
    self._ptr.contents.editcursor = value

  @property
  def editscroll(self):
    """horizontal scroll."""
    return self._ptr.contents.editscroll

  @editscroll.setter
  def editscroll(self, value):
    self._ptr.contents.editscroll = value

  @property
  def edittext(self):
    """current text."""
    return self._ptr.contents.edittext

  @property
  def editchanged(self):
    """pointer to changed edit in last mjui_event."""
    return self._ptr.contents.editchanged

  @editchanged.setter
  def editchanged(self, value):
    self._ptr.contents.editchanged = value

  @property
  def nsect(self):
    """number of sections in use."""
    return self._ptr.contents.nsect

  @nsect.setter
  def nsect(self, value):
    self._ptr.contents.nsect = value

  @util.CachedProperty
  def sect(self):
    """preallocated array of sections."""
    return util.buf_to_npy(self._ptr.contents.sect, (10,))


class MjuiDefWrapper(util.WrapperBase):
  """<no header comment found>."""

  @property
  def type_(self):
    """type (mjtItem); -1: section."""
    return self._ptr.contents.type_

  @type_.setter
  def type_(self, value):
    self._ptr.contents.type_ = value

  @property
  def name(self):
    """name."""
    return self._ptr.contents.name

  @property
  def state(self):
    """state."""
    return self._ptr.contents.state

  @state.setter
  def state(self, value):
    self._ptr.contents.state = value

  @property
  def pdata(self):
    """pointer to data."""
    return self._ptr.contents.pdata

  @pdata.setter
  def pdata(self, value):
    self._ptr.contents.pdata = value

  @property
  def other(self):
    """string with type-specific properties."""
    return self._ptr.contents.other


class MjvPerturbWrapper(util.WrapperBase):
  """object selection and perturbation."""

  @property
  def select(self):
    """selected body id; non-positive: none."""
    return self._ptr.contents.select

  @select.setter
  def select(self, value):
    self._ptr.contents.select = value

  @property
  def skinselect(self):
    """selected skin id; non-positive: none."""
    return self._ptr.contents.skinselect

  @skinselect.setter
  def skinselect(self, value):
    self._ptr.contents.skinselect = value

  @property
  def active(self):
    """perturbation bitmask (mjtPertBit)."""
    return self._ptr.contents.active

  @active.setter
  def active(self, value):
    self._ptr.contents.active = value

  @util.CachedProperty
  def refpos(self):
    """desired position for selected object."""
    return util.buf_to_npy(self._ptr.contents.refpos, (3,))

  @util.CachedProperty
  def refquat(self):
    """desired orientation for selected object."""
    return util.buf_to_npy(self._ptr.contents.refquat, (4,))

  @util.CachedProperty
  def localpos(self):
    """selection point in object coordinates."""
    return util.buf_to_npy(self._ptr.contents.localpos, (3,))

  @property
  def scale(self):
    """relative mouse motion-to-space scaling (set by initPerturb)."""
    return self._ptr.contents.scale

  @scale.setter
  def scale(self, value):
    self._ptr.contents.scale = value


class MjvCameraWrapper(util.WrapperBase):
  """abstract camera."""

  @property
  def type_(self):
    """camera type (mjtCamera)."""
    return self._ptr.contents.type_

  @type_.setter
  def type_(self, value):
    self._ptr.contents.type_ = value

  @property
  def fixedcamid(self):
    """fixed camera id."""
    return self._ptr.contents.fixedcamid

  @fixedcamid.setter
  def fixedcamid(self, value):
    self._ptr.contents.fixedcamid = value

  @property
  def trackbodyid(self):
    """body id to track."""
    return self._ptr.contents.trackbodyid

  @trackbodyid.setter
  def trackbodyid(self, value):
    self._ptr.contents.trackbodyid = value

  @util.CachedProperty
  def lookat(self):
    """lookat point."""
    return util.buf_to_npy(self._ptr.contents.lookat, (3,))

  @property
  def distance(self):
    """distance to lookat point or tracked body."""
    return self._ptr.contents.distance

  @distance.setter
  def distance(self, value):
    self._ptr.contents.distance = value

  @property
  def azimuth(self):
    """camera azimuth (deg)."""
    return self._ptr.contents.azimuth

  @azimuth.setter
  def azimuth(self, value):
    self._ptr.contents.azimuth = value

  @property
  def elevation(self):
    """camera elevation (deg)."""
    return self._ptr.contents.elevation

  @elevation.setter
  def elevation(self, value):
    self._ptr.contents.elevation = value


class MjvGLCameraWrapper(util.WrapperBase):
  """OpenGL camera."""

  @util.CachedProperty
  def pos(self):
    """position."""
    return util.buf_to_npy(self._ptr.contents.pos, (3,))

  @util.CachedProperty
  def forward(self):
    """forward direction."""
    return util.buf_to_npy(self._ptr.contents.forward, (3,))

  @util.CachedProperty
  def up(self):
    """up direction."""
    return util.buf_to_npy(self._ptr.contents.up, (3,))

  @property
  def frustum_center(self):
    """hor. center (left,right set to match aspect)."""
    return self._ptr.contents.frustum_center

  @frustum_center.setter
  def frustum_center(self, value):
    self._ptr.contents.frustum_center = value

  @property
  def frustum_bottom(self):
    """bottom."""
    return self._ptr.contents.frustum_bottom

  @frustum_bottom.setter
  def frustum_bottom(self, value):
    self._ptr.contents.frustum_bottom = value

  @property
  def frustum_top(self):
    """top."""
    return self._ptr.contents.frustum_top

  @frustum_top.setter
  def frustum_top(self, value):
    self._ptr.contents.frustum_top = value

  @property
  def frustum_near(self):
    """near."""
    return self._ptr.contents.frustum_near

  @frustum_near.setter
  def frustum_near(self, value):
    self._ptr.contents.frustum_near = value

  @property
  def frustum_far(self):
    """far."""
    return self._ptr.contents.frustum_far

  @frustum_far.setter
  def frustum_far(self, value):
    self._ptr.contents.frustum_far = value


class MjvGeomWrapper(util.WrapperBase):
  """abstract geom."""

  @property
  def type_(self):
    """geom type (mjtGeom)."""
    return self._ptr.contents.type_

  @type_.setter
  def type_(self, value):
    self._ptr.contents.type_ = value

  @property
  def dataid(self):
    """mesh, hfield or plane id; -1: none."""
    return self._ptr.contents.dataid

  @dataid.setter
  def dataid(self, value):
    self._ptr.contents.dataid = value

  @property
  def objtype(self):
    """mujoco object type; mjOBJ_UNKNOWN for decor."""
    return self._ptr.contents.objtype

  @objtype.setter
  def objtype(self, value):
    self._ptr.contents.objtype = value

  @property
  def objid(self):
    """mujoco object id; -1 for decor."""
    return self._ptr.contents.objid

  @objid.setter
  def objid(self, value):
    self._ptr.contents.objid = value

  @property
  def category(self):
    """visual category."""
    return self._ptr.contents.category

  @category.setter
  def category(self, value):
    self._ptr.contents.category = value

  @property
  def texid(self):
    """texture id; -1: no texture."""
    return self._ptr.contents.texid

  @texid.setter
  def texid(self, value):
    self._ptr.contents.texid = value

  @property
  def texuniform(self):
    """uniform cube mapping."""
    return self._ptr.contents.texuniform

  @texuniform.setter
  def texuniform(self, value):
    self._ptr.contents.texuniform = value

  @property
  def texcoord(self):
    """mesh geom has texture coordinates."""
    return self._ptr.contents.texcoord

  @texcoord.setter
  def texcoord(self, value):
    self._ptr.contents.texcoord = value

  @property
  def segid(self):
    """segmentation id; -1: not shown."""
    return self._ptr.contents.segid

  @segid.setter
  def segid(self, value):
    self._ptr.contents.segid = value

  @util.CachedProperty
  def texrepeat(self):
    """texture repetition for 2D mapping."""
    return util.buf_to_npy(self._ptr.contents.texrepeat, (2,))

  @util.CachedProperty
  def size(self):
    """size parameters."""
    return util.buf_to_npy(self._ptr.contents.size, (3,))

  @util.CachedProperty
  def pos(self):
    """Cartesian position."""
    return util.buf_to_npy(self._ptr.contents.pos, (3,))

  @util.CachedProperty
  def mat(self):
    """Cartesian orientation."""
    return util.buf_to_npy(self._ptr.contents.mat, (9,))

  @util.CachedProperty
  def rgba(self):
    """color and transparency."""
    return util.buf_to_npy(self._ptr.contents.rgba, (4,))

  @property
  def emission(self):
    """emission coef."""
    return self._ptr.contents.emission

  @emission.setter
  def emission(self, value):
    self._ptr.contents.emission = value

  @property
  def specular(self):
    """specular coef."""
    return self._ptr.contents.specular

  @specular.setter
  def specular(self, value):
    self._ptr.contents.specular = value

  @property
  def shininess(self):
    """shininess coef."""
    return self._ptr.contents.shininess

  @shininess.setter
  def shininess(self, value):
    self._ptr.contents.shininess = value

  @property
  def reflectance(self):
    """reflectance coef."""
    return self._ptr.contents.reflectance

  @reflectance.setter
  def reflectance(self, value):
    self._ptr.contents.reflectance = value

  @property
  def label(self):
    """text label."""
    return self._ptr.contents.label

  @property
  def camdist(self):
    """distance to camera (used by sorter)."""
    return self._ptr.contents.camdist

  @camdist.setter
  def camdist(self, value):
    self._ptr.contents.camdist = value

  @property
  def modelrbound(self):
    """geom rbound from model, 0 if not model geom."""
    return self._ptr.contents.modelrbound

  @modelrbound.setter
  def modelrbound(self, value):
    self._ptr.contents.modelrbound = value

  @property
  def transparent(self):
    """treat geom as transparent."""
    return self._ptr.contents.transparent

  @transparent.setter
  def transparent(self, value):
    self._ptr.contents.transparent = value


class MjvLightWrapper(util.WrapperBase):
  """OpenGL light."""

  @util.CachedProperty
  def pos(self):
    """position rel. to body frame."""
    return util.buf_to_npy(self._ptr.contents.pos, (3,))

  @util.CachedProperty
  def dir_(self):
    """direction rel. to body frame."""
    return util.buf_to_npy(self._ptr.contents.dir_, (3,))

  @util.CachedProperty
  def attenuation(self):
    """OpenGL attenuation (quadratic model)."""
    return util.buf_to_npy(self._ptr.contents.attenuation, (3,))

  @property
  def cutoff(self):
    """OpenGL cutoff."""
    return self._ptr.contents.cutoff

  @cutoff.setter
  def cutoff(self, value):
    self._ptr.contents.cutoff = value

  @property
  def exponent(self):
    """OpenGL exponent."""
    return self._ptr.contents.exponent

  @exponent.setter
  def exponent(self, value):
    self._ptr.contents.exponent = value

  @util.CachedProperty
  def ambient(self):
    """ambient rgb (alpha=1)."""
    return util.buf_to_npy(self._ptr.contents.ambient, (3,))

  @util.CachedProperty
  def diffuse(self):
    """diffuse rgb (alpha=1)."""
    return util.buf_to_npy(self._ptr.contents.diffuse, (3,))

  @util.CachedProperty
  def specular(self):
    """specular rgb (alpha=1)."""
    return util.buf_to_npy(self._ptr.contents.specular, (3,))

  @property
  def headlight(self):
    """headlight."""
    return self._ptr.contents.headlight

  @headlight.setter
  def headlight(self, value):
    self._ptr.contents.headlight = value

  @property
  def directional(self):
    """directional light."""
    return self._ptr.contents.directional

  @directional.setter
  def directional(self, value):
    self._ptr.contents.directional = value

  @property
  def castshadow(self):
    """does light cast shadows."""
    return self._ptr.contents.castshadow

  @castshadow.setter
  def castshadow(self, value):
    self._ptr.contents.castshadow = value


class MjvOptionWrapper(util.WrapperBase):
  """abstract visualization options."""

  @property
  def label(self):
    """what objects to label (mjtLabel)."""
    return self._ptr.contents.label

  @label.setter
  def label(self, value):
    self._ptr.contents.label = value

  @property
  def frame(self):
    """which frame to show (mjtFrame)."""
    return self._ptr.contents.frame

  @frame.setter
  def frame(self, value):
    self._ptr.contents.frame = value

  @util.CachedProperty
  def geomgroup(self):
    """geom visualization by group."""
    return util.buf_to_npy(self._ptr.contents.geomgroup, (6,))

  @util.CachedProperty
  def sitegroup(self):
    """site visualization by group."""
    return util.buf_to_npy(self._ptr.contents.sitegroup, (6,))

  @util.CachedProperty
  def jointgroup(self):
    """joint visualization by group."""
    return util.buf_to_npy(self._ptr.contents.jointgroup, (6,))

  @util.CachedProperty
  def tendongroup(self):
    """tendon visualization by group."""
    return util.buf_to_npy(self._ptr.contents.tendongroup, (6,))

  @util.CachedProperty
  def actuatorgroup(self):
    """actuator visualization by group."""
    return util.buf_to_npy(self._ptr.contents.actuatorgroup, (6,))

  @util.CachedProperty
  def flags(self):
    """visualization flags (indexed by mjtVisFlag)."""
    return util.buf_to_npy(self._ptr.contents.flags, (22,))


class MjvSceneWrapper(util.WrapperBase):
  """abstract scene passed to OpenGL renderer."""

  @property
  def maxgeom(self):
    """size of allocated geom buffer."""
    return self._ptr.contents.maxgeom

  @maxgeom.setter
  def maxgeom(self, value):
    self._ptr.contents.maxgeom = value

  @property
  def ngeom(self):
    """number of geoms currently in buffer."""
    return self._ptr.contents.ngeom

  @ngeom.setter
  def ngeom(self, value):
    self._ptr.contents.ngeom = value

  @property
  def geoms(self):
    """buffer for geoms."""
    return self._ptr.contents.geoms

  @geoms.setter
  def geoms(self, value):
    self._ptr.contents.geoms = value

  @property
  def geomorder(self):
    """buffer for ordering geoms by distance to camera."""
    return self._ptr.contents.geomorder

  @geomorder.setter
  def geomorder(self, value):
    self._ptr.contents.geomorder = value

  @property
  def nskin(self):
    """number of skins."""
    return self._ptr.contents.nskin

  @nskin.setter
  def nskin(self, value):
    self._ptr.contents.nskin = value

  @property
  def skinfacenum(self):
    """number of faces in skin."""
    return self._ptr.contents.skinfacenum

  @skinfacenum.setter
  def skinfacenum(self, value):
    self._ptr.contents.skinfacenum = value

  @property
  def skinvertadr(self):
    """address of skin vertices."""
    return self._ptr.contents.skinvertadr

  @skinvertadr.setter
  def skinvertadr(self, value):
    self._ptr.contents.skinvertadr = value

  @property
  def skinvertnum(self):
    """number of vertices in skin."""
    return self._ptr.contents.skinvertnum

  @skinvertnum.setter
  def skinvertnum(self, value):
    self._ptr.contents.skinvertnum = value

  @property
  def skinvert(self):
    """skin vertex data."""
    return self._ptr.contents.skinvert

  @skinvert.setter
  def skinvert(self, value):
    self._ptr.contents.skinvert = value

  @property
  def skinnormal(self):
    """skin normal data."""
    return self._ptr.contents.skinnormal

  @skinnormal.setter
  def skinnormal(self, value):
    self._ptr.contents.skinnormal = value

  @property
  def nlight(self):
    """number of lights currently in buffer."""
    return self._ptr.contents.nlight

  @nlight.setter
  def nlight(self, value):
    self._ptr.contents.nlight = value

  @util.CachedProperty
  def lights(self):
    """buffer for lights."""
    return util.buf_to_npy(self._ptr.contents.lights, (8,))

  @util.CachedProperty
  def camera(self):
    """left and right camera."""
    return util.buf_to_npy(self._ptr.contents.camera, (2,))

  @property
  def enabletransform(self):
    """enable model transformation."""
    return self._ptr.contents.enabletransform

  @enabletransform.setter
  def enabletransform(self, value):
    self._ptr.contents.enabletransform = value

  @util.CachedProperty
  def translate(self):
    """model translation."""
    return util.buf_to_npy(self._ptr.contents.translate, (3,))

  @util.CachedProperty
  def rotate(self):
    """model quaternion rotation."""
    return util.buf_to_npy(self._ptr.contents.rotate, (4,))

  @property
  def scale(self):
    """model scaling."""
    return self._ptr.contents.scale

  @scale.setter
  def scale(self, value):
    self._ptr.contents.scale = value

  @property
  def stereo(self):
    """stereoscopic rendering (mjtStereo)."""
    return self._ptr.contents.stereo

  @stereo.setter
  def stereo(self, value):
    self._ptr.contents.stereo = value

  @util.CachedProperty
  def flags(self):
    """rendering flags (indexed by mjtRndFlag)."""
    return util.buf_to_npy(self._ptr.contents.flags, (9,))


class MjvFigureWrapper(util.WrapperBase):
  """abstract 2D figure passed to OpenGL renderer."""

  @property
  def flg_legend(self):
    """show legend."""
    return self._ptr.contents.flg_legend

  @flg_legend.setter
  def flg_legend(self, value):
    self._ptr.contents.flg_legend = value

  @util.CachedProperty
  def flg_ticklabel(self):
    """show grid tick labels (x,y)."""
    return util.buf_to_npy(self._ptr.contents.flg_ticklabel, (2,))

  @property
  def flg_extend(self):
    """automatically extend axis ranges to fit data."""
    return self._ptr.contents.flg_extend

  @flg_extend.setter
  def flg_extend(self, value):
    self._ptr.contents.flg_extend = value

  @property
  def flg_barplot(self):
    """isolated line segments (i.e. GL_LINES)."""
    return self._ptr.contents.flg_barplot

  @flg_barplot.setter
  def flg_barplot(self, value):
    self._ptr.contents.flg_barplot = value

  @property
  def flg_selection(self):
    """vertical selection line."""
    return self._ptr.contents.flg_selection

  @flg_selection.setter
  def flg_selection(self, value):
    self._ptr.contents.flg_selection = value

  @property
  def flg_symmetric(self):
    """symmetric y-axis."""
    return self._ptr.contents.flg_symmetric

  @flg_symmetric.setter
  def flg_symmetric(self, value):
    self._ptr.contents.flg_symmetric = value

  @property
  def legendoff(self):
    """number of lines to offset legend."""
    return self._ptr.contents.legendoff

  @legendoff.setter
  def legendoff(self, value):
    self._ptr.contents.legendoff = value

  @util.CachedProperty
  def gridsize(self):
    """number of grid points in (x,y)."""
    return util.buf_to_npy(self._ptr.contents.gridsize, (2,))

  @property
  def selection(self):
    """selection line x-value."""
    return self._ptr.contents.selection

  @selection.setter
  def selection(self, value):
    self._ptr.contents.selection = value

  @util.CachedProperty
  def highlight(self):
    """if point is in legend rect, highlight line."""
    return util.buf_to_npy(self._ptr.contents.highlight, (2,))

  @util.CachedProperty
  def gridrgb(self):
    """grid line rgb."""
    return util.buf_to_npy(self._ptr.contents.gridrgb, (3,))

  @property
  def gridwidth(self):
    """grid line width."""
    return self._ptr.contents.gridwidth

  @gridwidth.setter
  def gridwidth(self, value):
    self._ptr.contents.gridwidth = value

  @util.CachedProperty
  def figurergba(self):
    """figure color and alpha."""
    return util.buf_to_npy(self._ptr.contents.figurergba, (4,))

  @util.CachedProperty
  def panergba(self):
    """pane color and alpha."""
    return util.buf_to_npy(self._ptr.contents.panergba, (4,))

  @util.CachedProperty
  def legendrgba(self):
    """legend color and alpha."""
    return util.buf_to_npy(self._ptr.contents.legendrgba, (4,))

  @util.CachedProperty
  def textrgb(self):
    """text color."""
    return util.buf_to_npy(self._ptr.contents.textrgb, (3,))

  @util.CachedProperty
  def range_(self):
    """axis ranges; (min>=max) automatic."""
    return util.buf_to_npy(self._ptr.contents.range_, (2, 2))

  @property
  def xlabel(self):
    """x-axis label."""
    return self._ptr.contents.xlabel

  @property
  def title(self):
    """figure title."""
    return self._ptr.contents.title

  @property
  def xformat(self):
    """x-tick label format for sprintf."""
    return self._ptr.contents.xformat

  @property
  def yformat(self):
    """y-tick label format for sprintf."""
    return self._ptr.contents.yformat

  @property
  def minwidth(self):
    """string used to determine min y-tick width."""
    return self._ptr.contents.minwidth

  @util.CachedProperty
  def linepnt(self):
    """number of points in line; (0) disable."""
    return util.buf_to_npy(self._ptr.contents.linepnt, (100,))

  @util.CachedProperty
  def linergb(self):
    """line color."""
    return util.buf_to_npy(self._ptr.contents.linergb, (100, 3))

  @util.CachedProperty
  def linewidth(self):
    """line width."""
    return util.buf_to_npy(self._ptr.contents.linewidth, (100,))

  @util.CachedProperty
  def linedata(self):
    """line data (x,y)."""
    return util.buf_to_npy(self._ptr.contents.linedata, (100, 2000))

  @property
  def linename(self):
    """line name for legend."""
    return self._ptr.contents.linename

  @util.CachedProperty
  def xaxispixel(self):
    """range of x-axis in pixels."""
    return util.buf_to_npy(self._ptr.contents.xaxispixel, (2,))

  @util.CachedProperty
  def yaxispixel(self):
    """range of y-axis in pixels."""
    return util.buf_to_npy(self._ptr.contents.yaxispixel, (2,))

  @util.CachedProperty
  def xaxisdata(self):
    """range of x-axis in data units."""
    return util.buf_to_npy(self._ptr.contents.xaxisdata, (2,))

  @util.CachedProperty
  def yaxisdata(self):
    """range of y-axis in data units."""
    return util.buf_to_npy(self._ptr.contents.yaxisdata, (2,))

# ----------------------------End of generated code----------------------------
